"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = exports.initialState = void 0;
var _constants = require("../../constants");
var t = _interopRequireWildcard(require("../action_types"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = exports.initialState = {
  status: {
    [_constants.SECTIONS.AUTO_FOLLOW_PATTERN]: _constants.API_STATUS.IDLE,
    [_constants.SECTIONS.FOLLOWER_INDEX]: _constants.API_STATUS.IDLE
  },
  error: {
    [_constants.SECTIONS.AUTO_FOLLOW_PATTERN]: null,
    [_constants.SECTIONS.FOLLOWER_INDEX]: null
  }
};
const reducer = (state = initialState, action) => {
  const payload = action.payload || {};
  const {
    scope,
    status,
    error
  } = payload;
  switch (action.type) {
    case t.API_REQUEST_START:
      {
        return {
          ...state,
          status: {
            ...state.status,
            [scope]: status
          }
        };
      }
    case t.API_REQUEST_END:
      {
        return {
          ...state,
          status: {
            ...state.status,
            [scope]: _constants.API_STATUS.IDLE
          }
        };
      }
    case t.API_ERROR_SET:
      {
        return {
          ...state,
          error: {
            ...state.error,
            [scope]: error
          }
        };
      }
    default:
      return state;
  }
};
exports.reducer = reducer;