"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaintenanceWindow = getMaintenanceWindow;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _transforms = require("../../transforms");
var _schemas = require("./schemas");
var _maintenance_window = require("../../../../data/maintenance_window");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getMaintenanceWindow(context, params) {
  const {
    savedObjectsClient,
    logger
  } = context;
  const {
    id
  } = params;
  try {
    _schemas.getMaintenanceWindowParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Error validating get maintenance window data - ${error.message}`);
  }
  try {
    const result = await (0, _maintenance_window.getMaintenanceWindowSo)({
      id,
      savedObjectsClient
    });
    return (0, _transforms.transformMaintenanceWindowAttributesToMaintenanceWindow)({
      attributes: result.attributes,
      id: result.id
    });
  } catch (e) {
    const errorMessage = `Failed to get maintenance window by id: ${id}, Error: ${e}`;
    logger.error(errorMessage);
    throw _boom.default.boomify(e, {
      message: errorMessage
    });
  }
}