"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const FileDataSource_1 = require("../data_sources/FileDataSource");
/**
 * Class for creating file data sources.
 */
class FileDataSourceFactory {
    constructor(_options) {
        this._options = _options;
    }
    /**
     * Method for creating instances of the file data source. This method is intended to be used
     * by the SDK.
     *
     * @param config SDK configuration required by the file data source.
     * @param filesystem Platform abstraction used for filesystem access.
     * @returns a {@link FileDataSource}
     *
     * @internal
     */
    create(ldClientContext, featureStore, initSuccessHandler, errorHandler) {
        const updatedOptions = {
            paths: this._options.paths,
            autoUpdate: this._options.autoUpdate,
            logger: this._options.logger || ldClientContext.basicConfiguration.logger,
            yamlParser: this._options.yamlParser,
        };
        return new FileDataSource_1.default(updatedOptions, ldClientContext.platform.fileSystem, featureStore, initSuccessHandler, errorHandler);
    }
    getFactory() {
        return (ldClientContext, featureStore, initSuccessHandler, errorHandler) => this.create(ldClientContext, featureStore, initSuccessHandler, errorHandler);
    }
}
exports.default = FileDataSourceFactory;
//# sourceMappingURL=FileDataSourceFactory.js.map