"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Reasons_1 = require("./Reasons");
/**
 * A class which encapsulates the result of an evaluation. It allows for differentiating between
 * successful and error result types.
 *
 * @internal
 */
class EvalResult {
    constructor(isError, detail, message) {
        this.isError = isError;
        this.detail = detail;
        this.message = message;
        this.isError = isError;
        this.detail = detail;
        this.message = message;
    }
    get isOff() {
        return this.detail.reason.kind === Reasons_1.default.Off.kind;
    }
    setDefault(def) {
        this.detail.value = def;
    }
    static forError(errorKind, message, def) {
        return new EvalResult(true, {
            value: def !== null && def !== void 0 ? def : null,
            variationIndex: null,
            reason: { kind: 'ERROR', errorKind },
        }, message);
    }
    static forSuccess(value, reason, variationIndex) {
        return new EvalResult(false, {
            value,
            variationIndex: variationIndex === undefined ? null : variationIndex,
            reason,
        });
    }
}
exports.default = EvalResult;
//# sourceMappingURL=EvalResult.js.map