"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createStreamListeners = exports.createDeleteListener = exports.createPatchListener = exports.createPutListener = void 0;
const js_sdk_common_1 = require("@launchdarkly/js-sdk-common");
const serialization_1 = require("../store/serialization");
const VersionedDataKinds_1 = require("../store/VersionedDataKinds");
const { initMetadataFromHeaders } = js_sdk_common_1.internal;
const createPutListener = (dataSourceUpdates, logger, onPutCompleteHandler = () => { }) => ({
    deserializeData: serialization_1.deserializeAll,
    processJson: async ({ data: { flags, segments } }, initHeaders) => {
        const initData = {
            [VersionedDataKinds_1.default.Features.namespace]: flags,
            [VersionedDataKinds_1.default.Segments.namespace]: segments,
        };
        logger === null || logger === void 0 ? void 0 : logger.debug('Initializing all data');
        dataSourceUpdates.init(initData, onPutCompleteHandler, initMetadataFromHeaders(initHeaders));
    },
});
exports.createPutListener = createPutListener;
const createPatchListener = (dataSourceUpdates, logger, onPatchCompleteHandler = () => { }) => ({
    deserializeData: serialization_1.deserializePatch,
    processJson: async ({ data, kind, path }) => {
        if (kind) {
            const key = VersionedDataKinds_1.default.getKeyFromPath(kind, path);
            if (key) {
                logger === null || logger === void 0 ? void 0 : logger.debug(`Updating ${key} in ${kind.namespace}`);
                dataSourceUpdates.upsert(kind, data, onPatchCompleteHandler);
            }
        }
    },
});
exports.createPatchListener = createPatchListener;
const createDeleteListener = (dataSourceUpdates, logger, onDeleteCompleteHandler = () => { }) => ({
    deserializeData: serialization_1.deserializeDelete,
    processJson: async ({ kind, path, version }) => {
        if (kind) {
            const key = VersionedDataKinds_1.default.getKeyFromPath(kind, path);
            if (key) {
                logger === null || logger === void 0 ? void 0 : logger.debug(`Deleting ${key} in ${kind.namespace}`);
                dataSourceUpdates.upsert(kind, {
                    key,
                    version,
                    deleted: true,
                }, onDeleteCompleteHandler);
            }
        }
    },
});
exports.createDeleteListener = createDeleteListener;
const createStreamListeners = (dataSourceUpdates, logger, onCompleteHandlers) => {
    const listeners = new Map();
    listeners.set('put', (0, exports.createPutListener)(dataSourceUpdates, logger, onCompleteHandlers === null || onCompleteHandlers === void 0 ? void 0 : onCompleteHandlers.put));
    listeners.set('patch', (0, exports.createPatchListener)(dataSourceUpdates, logger, onCompleteHandlers === null || onCompleteHandlers === void 0 ? void 0 : onCompleteHandlers.patch));
    listeners.set('delete', (0, exports.createDeleteListener)(dataSourceUpdates, logger, onCompleteHandlers === null || onCompleteHandlers === void 0 ? void 0 : onCompleteHandlers.delete));
    return listeners;
};
exports.createStreamListeners = createStreamListeners;
//# sourceMappingURL=createStreamListeners.js.map