"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const js_sdk_common_1 = require("@launchdarkly/js-sdk-common");
const serialization_1 = require("../store/serialization");
/**
 * @internal
 */
class OneShotInitializerFDv2 {
    constructor(_requestor, _logger) {
        this._requestor = _requestor;
        this._logger = _logger;
        this._stopped = false;
    }
    start(dataCallback, statusCallback) {
        var _a;
        statusCallback(js_sdk_common_1.subsystem.DataSourceState.Initializing);
        (_a = this._logger) === null || _a === void 0 ? void 0 : _a.debug('Performing initialization request to LaunchDarkly for feature flag data.');
        this._requestor.requestAllData((err, body, headers) => {
            var _a, _b, _c;
            if (this._stopped) {
                return;
            }
            if (err) {
                const { status } = err;
                const message = (0, js_sdk_common_1.httpErrorMessage)(err, 'initializer', 'initializer does not retry');
                (_a = this._logger) === null || _a === void 0 ? void 0 : _a.error(message);
                statusCallback(js_sdk_common_1.subsystem.DataSourceState.Closed, new js_sdk_common_1.LDPollingError(js_sdk_common_1.DataSourceErrorKind.ErrorResponse, message, status));
                return;
            }
            if (!body) {
                statusCallback(js_sdk_common_1.subsystem.DataSourceState.Closed, new js_sdk_common_1.LDPollingError(js_sdk_common_1.DataSourceErrorKind.InvalidData, 'One shot initializer response missing body.'));
                return;
            }
            const initMetadata = js_sdk_common_1.internal.initMetadataFromHeaders(headers);
            try {
                const parsed = JSON.parse(body);
                const payloadProcessor = new js_sdk_common_1.internal.PayloadProcessor({
                    flag: (flag) => {
                        (0, serialization_1.processFlag)(flag);
                        return flag;
                    },
                    segment: (segment) => {
                        (0, serialization_1.processSegment)(segment);
                        return segment;
                    },
                }, (errorKind, message) => {
                    statusCallback(js_sdk_common_1.subsystem.DataSourceState.Interrupted, new js_sdk_common_1.LDPollingError(errorKind, message));
                }, this._logger);
                statusCallback(js_sdk_common_1.subsystem.DataSourceState.Valid);
                payloadProcessor.addPayloadListener((payload) => {
                    dataCallback(payload.basis, { initMetadata, payload });
                });
                payloadProcessor.processEvents(parsed.events);
                statusCallback(js_sdk_common_1.subsystem.DataSourceState.Closed);
            }
            catch (error) {
                // We could not parse this JSON. Report the problem.
                (_b = this._logger) === null || _b === void 0 ? void 0 : _b.error('Response contained invalid data');
                (_c = this._logger) === null || _c === void 0 ? void 0 : _c.debug(`${err} - Body follows: ${body}`);
                statusCallback(js_sdk_common_1.subsystem.DataSourceState.Closed, new js_sdk_common_1.LDPollingError(js_sdk_common_1.DataSourceErrorKind.InvalidData, 'Malformed data in polling response'));
            }
        });
    }
    stop() {
        this._stopped = true;
    }
}
exports.default = OneShotInitializerFDv2;
//# sourceMappingURL=OneShotInitializerFDv2.js.map