"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmailActionFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _form_errors = require("../../../../../components/form_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmailActionFields = ({
  action,
  editAction,
  errors,
  hasErrors
}) => {
  const {
    to,
    subject,
    body
  } = action;
  const toOptions = to ? to.map(label => ({
    label
  })) : [];
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "emailRecipient",
    errorKey: "to",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && to !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.emailAction.recipientTextFieldLabel', {
      defaultMessage: 'To email address'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    fullWidth: true,
    "data-test-subj": "toEmailAddressInput",
    selectedOptions: toOptions,
    onCreateOption: searchValue => {
      const newOptions = [...toOptions, {
        label: searchValue
      }];
      editAction({
        key: 'to',
        value: newOptions.map(newOption => newOption.label)
      });
    },
    onChange: selectedOptions => {
      editAction({
        key: 'to',
        value: selectedOptions.map(selectedOption => selectedOption.label)
      });
    },
    onBlur: () => {
      if (!to) {
        editAction({
          key: 'to',
          value: []
        });
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.emailAction.subjectTextFieldLabel', {
      defaultMessage: 'Subject (optional)'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "subject",
    "data-test-subj": "emailSubjectInput",
    value: subject || '',
    onChange: e => {
      editAction({
        key: 'subject',
        value: e.target.value
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.emailAction.bodyTextAreaFieldLabel', {
      defaultMessage: 'Body'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    value: body || '',
    name: "body",
    "data-test-subj": "emailBodyInput",
    onChange: e => {
      editAction({
        key: 'body',
        value: e.target.value
      });
    }
  })));
};
exports.EmailActionFields = EmailActionFields;