"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecuteDetails = void 0;
var _i18n = require("@kbn/i18n");
var _format_date = require("../../lib/format_date");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ExecuteDetails {
  constructor(props = {}) {
    this.triggeredTimeValue = props.triggeredTimeValue;
    this.triggeredTimeUnit = props.triggeredTimeUnit;
    this.scheduledTimeValue = props.scheduledTimeValue;
    this.scheduledTimeUnit = props.scheduledTimeUnit;
    this.ignoreCondition = props.ignoreCondition;
    this.alternativeInput = props.alternativeInput || '';
    this.actionModes = props.actionModes;
    this.recordExecution = props.recordExecution;
  }
  validate() {
    const errors = {
      json: []
    };
    const invalidJsonFieldError = _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulate.form.invalidJsonFieldError', {
      defaultMessage: 'Invalid JSON'
    });
    if (this.alternativeInput !== '') {
      try {
        const parsedJson = JSON.parse(this.alternativeInput);
        if (parsedJson && typeof parsedJson !== 'object') {
          errors.json.push(invalidJsonFieldError);
        }
      } catch (e) {
        errors.json.push(invalidJsonFieldError);
      }
    }
    return errors;
  }
  get upstreamJson() {
    const triggeredTime = this.triggeredTimeValue && this.triggeredTimeValue !== '' ? (0, _format_date.getDateMathFormat)(this.triggeredTimeUnit, this.triggeredTimeValue) : undefined;
    const scheduledTime = this.scheduledTimeValue && this.scheduledTimeValue !== '' ? (0, _format_date.getDateMathFormat)(this.scheduledTimeUnit, this.scheduledTimeValue) : undefined;
    return {
      triggerData: {
        triggeredTime,
        scheduledTime
      },
      ignoreCondition: this.ignoreCondition,
      alternativeInput: this.alternativeInput !== '' ? JSON.parse(this.alternativeInput) : undefined,
      actionModes: this.actionModes,
      recordExecution: this.recordExecution
    };
  }
}
exports.ExecuteDetails = ExecuteDetails;