"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeNoMatch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

let bannerId;
const VisualizeNoMatch = () => {
  const {
    services
  } = (0, _public.useKibana)();
  (0, _react.useEffect)(() => {
    services.restorePreviousUrl();
    const {
      navigated
    } = services.urlForwarding.navigateToLegacyKibanaUrl(services.history.location.pathname + services.history.location.search);
    if (!navigated) {
      const bannerMessage = _i18n.i18n.translate('visualizations.noMatchRoute.bannerTitleText', {
        defaultMessage: 'Page not found'
      });
      bannerId = services.overlays.banners.replace(bannerId, (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        iconType: "info",
        title: bannerMessage
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visualizations.noMatchRoute.bannerText",
        defaultMessage: "Visualize application doesn't recognize this route: {route}.",
        values: {
          route: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: window.location.href
          }, services.history.location.pathname)
        }
      }))), services.core));

      // hide the message after the user has had a chance to acknowledge it -- so it doesn't permanently stick around
      setTimeout(() => {
        services.overlays.banners.remove(bannerId);
      }, 15000);
      services.history.replace(_constants.VisualizeConstants.LANDING_PAGE_PATH);
    }
  }, [services]);
  return null;
};
exports.VisualizeNoMatch = VisualizeNoMatch;