"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensVisualizationType = exports.ChartType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Indicates what was changed in this table compared to the currently active table of this layer.
 * * `initial` means the layer associated with this table does not exist in the current configuration
 * * `unchanged` means the table is the same in the currently active configuration
 * * `reduced` means the table is a reduced version of the currently active table (some columns dropped, but not all of them)
 * * `extended` means the table is an extended version of the currently active table (added one or multiple additional columns)
 * * `reorder` means the table columns have changed order, which change the data as well
 * * `layers` means the change is a change to the layer structure, not to the table
 */
let ChartType = exports.ChartType = /*#__PURE__*/function (ChartType) {
  ChartType["XY"] = "XY";
  ChartType["Gauge"] = "Gauge";
  ChartType["Bar"] = "Bar";
  ChartType["Line"] = "Line";
  ChartType["Area"] = "Area";
  ChartType["Donut"] = "Donut";
  ChartType["Heatmap"] = "Heatmap";
  ChartType["Metric"] = "Metric";
  ChartType["Treemap"] = "Treemap";
  ChartType["Tagcloud"] = "Tagcloud";
  ChartType["Waffle"] = "Waffle";
  ChartType["Pie"] = "Pie";
  ChartType["Mosaic"] = "Mosaic";
  ChartType["Table"] = "Table";
  return ChartType;
}({});
let LensVisualizationType = exports.LensVisualizationType = /*#__PURE__*/function (LensVisualizationType) {
  LensVisualizationType["XY"] = "lnsXY";
  LensVisualizationType["Metric"] = "lnsMetric";
  LensVisualizationType["Pie"] = "lnsPie";
  LensVisualizationType["Heatmap"] = "lnsHeatmap";
  LensVisualizationType["Gauge"] = "lnsGauge";
  LensVisualizationType["Datatable"] = "lnsDatatable";
  LensVisualizationType["LegacyMetric"] = "lnsLegacyMetric";
  LensVisualizationType["Tagcloud"] = "lnsTagcloud";
  return LensVisualizationType;
}({});