"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getYAxisPosition = exports.getMode = exports.getLineStyle = exports.getCurveType = void 0;
var _charts = require("@elastic/charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getCurveType = type => {
  switch (type) {
    case 'cardinal':
      return 'CURVE_MONOTONE_X';
    case 'step-after':
      return 'CURVE_STEP_AFTER';
    case 'linear':
    default:
      return 'LINEAR';
  }
};
exports.getCurveType = getCurveType;
const getMode = (scale, bounds) => {
  if (scale.defaultYExtents) {
    return 'dataBounds';
  }
  if (scale.setYExtents || bounds) {
    return 'custom';
  }
  return 'full';
};
exports.getMode = getMode;
const getYAxisPosition = position => {
  if (position === _charts.Position.Top) {
    return _charts.Position.Right;
  }
  if (position === _charts.Position.Bottom) {
    return _charts.Position.Left;
  }
  return position;
};
exports.getYAxisPosition = getYAxisPosition;
const getLineStyle = style => {
  switch (style) {
    case 'full':
      return 'solid';
    case 'dashed':
    case 'dot-dashed':
      return style;
  }
};
exports.getLineStyle = getLineStyle;