"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAddVegaPanelAction = getAddVegaPanelAction;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/embeddable-plugin/public");
var _vega_type = require("./vega_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getAddVegaPanelAction(deps) {
  return {
    id: 'addVegaPanelAction',
    getIconType: () => _vega_type.vegaVisType.icon,
    order: 0,
    isCompatible: async () => true,
    execute: async ({
      embeddable
    }) => {
      var _embeddable$getAppCon, _embeddable$getAppCon2;
      const stateTransferService = deps.embeddable.getStateTransfer();
      stateTransferService.navigateToEditor('visualize', {
        path: '#/create?type=vega',
        state: {
          originatingApp: (0, _presentationPublishing.apiHasAppContext)(embeddable) ? embeddable.getAppContext().currentAppId : '',
          originatingPath: (0, _presentationPublishing.apiHasAppContext)(embeddable) ? (_embeddable$getAppCon = (_embeddable$getAppCon2 = embeddable.getAppContext()).getCurrentPath) === null || _embeddable$getAppCon === void 0 ? void 0 : _embeddable$getAppCon.call(_embeddable$getAppCon2) : undefined,
          searchSessionId: deps.data.search.session.getSessionId()
        }
      });
    },
    grouping: [_public.ADD_PANEL_VISUALIZATION_GROUP],
    getDisplayName: () => _vega_type.vegaVisType.titleInWizard,
    getDisplayNameTooltip: () => _vega_type.vegaVisType.description
  };
}