"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPipelineSeriesFormula = void 0;
var _enums = require("../../../../common/enums");
var _supported_metrics = require("./supported_metrics");
var _metrics_helpers = require("./metrics_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getAdditionalArgs = metric => {
  if (metric.type === _enums.TSVB_METRIC_TYPES.POSITIVE_ONLY) {
    return `, 0`;
  }
  if (metric.type === _enums.TSVB_METRIC_TYPES.MOVING_AVERAGE) {
    return `, window=${metric.window || 5}`;
  }
  return '';
};
const getPipelineSeriesFormula = (metric, metrics, subFunctionMetric, {
  metaValue,
  reducedTimeRange,
  timeShift
} = {}) => {
  const aggregationMap = _supported_metrics.SUPPORTED_METRICS[metric.type];
  if (!aggregationMap) {
    return null;
  }
  if (!subFunctionMetric || subFunctionMetric.type === 'static') {
    return null;
  }
  const aggFormula = (0, _supported_metrics.getFormulaFromMetric)(aggregationMap);
  const subFormula = (0, _metrics_helpers.getFormulaEquivalent)(subFunctionMetric, metrics, {
    metaValue,
    reducedTimeRange,
    timeShift
  });
  if (!subFormula) {
    return null;
  }
  const additionalArgs = getAdditionalArgs(metric);
  const formula = `${aggFormula}(${subFormula}${additionalArgs})`;
  return metric.unit ? `normalize_by_unit(${formula}, unit='${(0, _metrics_helpers.getTimeScale)(metric)}')` : formula;
};
exports.getPipelineSeriesFormula = getPipelineSeriesFormula;