"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPercentileColumnWithMeta = exports.convertToPercentileParams = exports.convertToPercentileColumns = exports.convertToPercentileColumn = void 0;
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _column = require("./column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isPercentileColumnWithMeta = column => {
  var _meta;
  return column.operationType === _convert_to_lens.Operations.PERCENTILE && Boolean(column === null || column === void 0 ? void 0 : (_meta = column.meta) === null || _meta === void 0 ? void 0 : _meta.reference);
};
exports.isPercentileColumnWithMeta = isPercentileColumnWithMeta;
const convertToPercentileParams = value => value !== undefined && !isNaN(Number(value)) ? {
  percentile: Number(value)
} : null;
exports.convertToPercentileParams = convertToPercentileParams;
const convertToPercentileColumn = (percentile, {
  series,
  metric,
  dataView
}, {
  index,
  reducedTimeRange,
  timeShift
} = {}) => {
  var _metric$field;
  const params = convertToPercentileParams(percentile);
  if (!params) {
    return null;
  }
  const field = dataView.getFieldByName((_metric$field = metric.field) !== null && _metric$field !== void 0 ? _metric$field : 'document');
  if (!field) {
    return null;
  }
  const commonColumnParams = (0, _column.createColumn)(series, metric, field, {
    reducedTimeRange,
    timeShift
  });
  const meta = index !== undefined ? {
    reference: `${metric.id}.${index}`,
    ...commonColumnParams.meta
  } : commonColumnParams.meta;
  return {
    operationType: 'percentile',
    sourceField: field.name,
    ...commonColumnParams,
    params: {
      ...params,
      ...(0, _column.getFormat)(series)
    },
    meta
  };
};
exports.convertToPercentileColumn = convertToPercentileColumn;
const convertToPercentileColumns = (columnConverterArgs, additionalArgs) => {
  const {
    percentiles
  } = columnConverterArgs.metric;
  if (!percentiles) {
    return null;
  }
  return percentiles.map((p, index) => convertToPercentileColumn(p.value, columnConverterArgs, {
    index,
    ...additionalArgs
  }));
};
exports.convertToPercentileColumns = convertToPercentileColumns;