"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertFilterRatioToFormulaColumn = void 0;
var _metrics = require("../metrics");
var _formula = require("./formula");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const convertFilterRatioToFormulaColumn = ({
  series,
  metrics,
  dataView
}, reducedTimeRange) => {
  const metric = metrics[metrics.length - 1];
  const formula = (0, _metrics.getFilterRatioFormula)(metric, {
    reducedTimeRange,
    timeShift: series.offset_time
  });
  if (!formula) {
    return null;
  }
  return (0, _formula.createFormulaColumn)(formula, {
    series,
    metric,
    dataView
  });
};
exports.convertFilterRatioToFormulaColumn = convertFilterRatioToFormulaColumn;