"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfigurationForTopN = exports.getConfigurationForTimeseries = void 0;
var _charts = require("@elastic/charts");
var _public = require("@kbn/visualizations-plugin/public");
var _extents = require("./extents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getConfigurationForTimeseries = (model, layers) => {
  var _Number, _ref, _model$max_lines_lege;
  const extents = (0, _extents.getYExtents)(model);
  return {
    layers,
    curveType: model.series[0].steps === 1 ? _public.XYCurveTypes.CURVE_STEP_AFTER : undefined,
    fillOpacity: (_Number = Number(model.series[0].fill)) !== null && _Number !== void 0 ? _Number : 0.3,
    legend: {
      isVisible: Boolean(model.show_legend),
      showSingleSeries: Boolean(model.show_legend),
      position: (_ref = model.legend_position) !== null && _ref !== void 0 ? _ref : _charts.Position.Right,
      shouldTruncate: Boolean(model.truncate_legend),
      maxLines: (_model$max_lines_lege = model.max_lines_legend) !== null && _model$max_lines_lege !== void 0 ? _model$max_lines_lege : 1
    },
    gridlinesVisibilitySettings: {
      x: Boolean(model.show_grid),
      yLeft: Boolean(model.show_grid),
      yRight: Boolean(model.show_grid)
    },
    yLeftExtent: extents.yLeftExtent,
    yRightExtent: extents.yRightExtent,
    yLeftScale: model.axis_scale === 'log' ? 'log' : 'linear',
    yRightScale: model.axis_scale === 'log' ? 'log' : 'linear'
  };
};
exports.getConfigurationForTimeseries = getConfigurationForTimeseries;
const getConfigurationForTopN = (model, layers) => {
  var _Number2, _ref2, _model$max_lines_lege2;
  return {
    layers,
    fillOpacity: (_Number2 = Number(model.series[0].fill)) !== null && _Number2 !== void 0 ? _Number2 : 0.3,
    legend: {
      isVisible: Boolean(model.show_legend),
      showSingleSeries: Boolean(model.show_legend),
      position: (_ref2 = model.legend_position) !== null && _ref2 !== void 0 ? _ref2 : _charts.Position.Right,
      shouldTruncate: Boolean(model.truncate_legend),
      maxLines: (_model$max_lines_lege2 = model.max_lines_legend) !== null && _model$max_lines_lege2 !== void 0 ? _model$max_lines_lege2 : 1
    },
    gridlinesVisibilitySettings: {
      x: false,
      yLeft: false,
      yRight: false
    },
    tickLabelsVisibilitySettings: {
      x: true,
      yLeft: false,
      yRight: false
    },
    axisTitlesVisibilitySettings: {
      x: false,
      yLeft: false,
      yRight: false
    },
    valueLabels: 'show'
  };
};
exports.getConfigurationForTopN = getConfigurationForTopN;