"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.computeGradientFinalColor = void 0;
var _color = _interopRequireDefault(require("color"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const computeGradientFinalColor = color => {
  let inputColor = new _color.default(color);
  const hsl = inputColor.hsl().object();
  hsl.l -= inputColor.luminosity() * 100;
  inputColor = _color.default.hsl(hsl);
  return inputColor.rgb().toString();
};
exports.computeGradientFinalColor = computeGradientFinalColor;