"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PalettePicker = PalettePicker;
var _react = _interopRequireDefault(require("react"));
var _coloring = require("@kbn/coloring");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _rainbow_colors = require("../lib/rainbow_colors");
var _compute_gradient_final_color = require("../lib/compute_gradient_final_color");
var _enums = require("../../../common/enums");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function PalettePicker({
  activePalette,
  palettes,
  setPalette,
  color
}) {
  const finalGradientColor = (0, _compute_gradient_final_color.computeGradientFinalColor)(color);
  const paletteName = (0, _coloring.getActivePaletteName)(activePalette === null || activePalette === void 0 ? void 0 : activePalette.name);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiColorPalettePicker, {
    fullWidth: true,
    "data-test-subj": "visEditorPalettePicker",
    compressed: true,
    palettes: [...palettes.getAll().filter(({
      internal
    }) => !internal).map(({
      id,
      title,
      getCategoricalColors
    }) => {
      return {
        value: id,
        title,
        type: 'fixed',
        palette: getCategoricalColors(10)
      };
    }), {
      value: _enums.PALETTES.GRADIENT,
      title: _i18n.i18n.translate('visTypeTimeseries.timeSeries.gradientLabel', {
        defaultMessage: 'Gradient'
      }),
      type: 'fixed',
      palette: palettes.get('custom').getCategoricalColors(10, {
        colors: [color, finalGradientColor],
        gradient: true
      })
    }, {
      value: _enums.PALETTES.RAINBOW,
      title: _i18n.i18n.translate('visTypeTimeseries.timeSeries.rainbowLabel', {
        defaultMessage: 'Rainbow'
      }),
      type: 'fixed',
      palette: palettes.get('custom').getCategoricalColors(10, {
        colors: _rainbow_colors.rainbowColors.slice(0, 10),
        gradient: false
      })
    }],
    onChange: newPalette => {
      if (newPalette === _enums.PALETTES.RAINBOW) {
        setPalette({
          type: 'palette',
          name: _enums.PALETTES.RAINBOW,
          params: {
            colors: _rainbow_colors.rainbowColors,
            gradient: false
          }
        });
      } else if (newPalette === _enums.PALETTES.GRADIENT) {
        setPalette({
          type: 'palette',
          name: _enums.PALETTES.GRADIENT,
          params: {
            colors: [color, finalGradientColor],
            gradient: true
          }
        });
      } else {
        setPalette({
          type: 'palette',
          name: newPalette
        });
      }
    },
    valueOfSelected: paletteName,
    selectionDisplay: 'palette'
  });
}