"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = void 0;
var _lodash = require("lodash");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/expressions-plugin/public");
var _common = require("@kbn/expressions-plugin/common");
var _public3 = require("@kbn/charts-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const prepareDimension = params => {
  const visdimension = (0, _public2.buildExpressionFunction)('visdimension', {
    accessor: params.accessor
  });
  if (params.format) {
    visdimension.addArgument('format', params.format.id);
    visdimension.addArgument('formatParams', JSON.stringify(params.format.params));
  }
  return (0, _public2.buildExpression)([visdimension]);
};
const toExpressionAst = (vis, params) => {
  var _labels$show;
  const schemas = (0, _public.getVisSchemas)(vis, params);
  const {
    percentageMode,
    percentageFormatPattern,
    colorSchema,
    metricColorMode,
    colorsRange,
    labels,
    invertColors,
    style
  } = vis.params.metric;

  // fix formatter for percentage mode
  if ((0, _lodash.get)(vis.params, 'metric.percentageMode') === true) {
    schemas.metric.forEach(metric => {
      metric.format = {
        id: 'percent',
        params: {
          pattern: percentageFormatPattern
        }
      };
    });
  }
  const hasColorRanges = colorsRange && colorsRange.length > 1;
  const metricVis = (0, _public2.buildExpressionFunction)('legacyMetricVis', {
    percentageMode,
    colorMode: hasColorRanges ? metricColorMode : _public3.ColorMode.None,
    showLabels: (_labels$show = labels === null || labels === void 0 ? void 0 : labels.show) !== null && _labels$show !== void 0 ? _labels$show : false
  });

  // Pt unit is provided to support the previous view of the metricVis at vis_types editor.
  // Inter font is defined here to override the default `openSans` font, which comes from the expession.
  metricVis.addArgument('font', (0, _public2.buildExpression)(`font family="${_common.inter.value}"
        weight="bold"
        align="center"
        sizeUnit="pt"
        ${style ? `size=${style.fontSize}` : ''}`));
  metricVis.addArgument('labelFont', (0, _public2.buildExpression)(`font size="14" align="center"`));
  if (colorsRange && colorsRange.length) {
    const stopsWithColors = (0, _utils.getStopsWithColorsFromRanges)(colorsRange, colorSchema, invertColors);
    const palette = (0, _public2.buildExpressionFunction)('palette', {
      ...stopsWithColors,
      range: 'number',
      continuity: 'none'
    });
    metricVis.addArgument('palette', (0, _public2.buildExpression)([palette]));
  }
  if (schemas.group) {
    metricVis.addArgument('bucket', prepareDimension(schemas.group[0]));
  }
  schemas.metric.forEach(metric => {
    metricVis.addArgument('metric', prepareDimension(metric));
  });
  const ast = (0, _public2.buildExpression)([metricVis]);
  return ast.toAst();
};
exports.toExpressionAst = toExpressionAst;