"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/alerting-plugin/common");
var _server = require("@kbn/rule-registry-plugin/server");
var _uptime_server = require("./legacy_uptime/uptime_server");
var _saved_objects = require("./legacy_uptime/lib/saved_objects/saved_objects");
var _synthetics_alerts = require("../common/constants/synthetics_alerts");
var _common2 = require("./legacy_uptime/lib/alerts/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Plugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "initContext", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "server", void 0);
    this.initContext = initializerContext;
    this.logger = initializerContext.logger.get();
  }
  setup(core, plugins) {
    const config = this.initContext.config.get();
    _saved_objects.savedObjectsAdapter.config = config;
    this.logger = this.initContext.logger.get();
    const {
      ruleDataService
    } = plugins.ruleRegistry;
    const ruleDataClient = ruleDataService.initializeIndex({
      feature: 'uptime',
      registrationContext: _synthetics_alerts.SYNTHETICS_RULE_TYPES_ALERT_CONTEXT,
      dataset: _server.Dataset.alerts,
      componentTemplateRefs: [],
      componentTemplates: [{
        name: 'mappings',
        mappings: (0, _common.mappingFromFieldMap)(_common2.uptimeRuleTypeFieldMap, 'strict')
      }]
    });
    this.server = {
      config,
      basePath: core.http.basePath,
      isDev: this.initContext.env.mode.dev,
      share: plugins.share
    };
    (0, _uptime_server.initUptimeServer)(this.server, plugins, ruleDataClient, this.logger, core.http.createRouter());
    (0, _saved_objects.registerUptimeSavedObjects)(core.savedObjects);
    return {
      ruleRegistry: ruleDataClient
    };
  }
  start(coreStart, pluginsStart) {}
  stop() {}
}
exports.Plugin = Plugin;