"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockKibanaProvider = MockKibanaProvider;
exports.MockRedux = void 0;
exports.MockRouter = MockRouter;
exports.WrappedHelper = WrappedHelper;
exports.mockCore = exports.makeUptimePermissionsCore = exports.forNearestButton = exports.forNearestAnchor = exports.defaultCore = void 0;
exports.render = render;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _react2 = require("@testing-library/react");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _lodash = require("lodash");
var _history = require("history");
var _i18nReact = require("@kbn/i18n-react");
var _mocks = require("@kbn/core/public/mocks");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _mocks2 = require("@kbn/triggers-actions-ui-plugin/public/mocks");
var _mocks3 = require("@kbn/data-plugin/public/mocks");
var _mocks4 = require("@kbn/unified-search-plugin/public/mocks");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _stringify_url_params = require("./url_params/stringify_url_params");
var _uptime_store = require("../__mocks__/uptime_store.mock");
var _helper_with_redux = require("./helper_with_redux");
var _contexts = require("../../contexts");
var _kibana_service = require("../../state/kibana_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-extraneous-dependencies

function getSetting(key) {
  return 'MMM D, YYYY @ HH:mm:ss.SSS';
}
function setSetting$(key) {
  return (0, _rxjs.of)('MMM D, YYYY @ HH:mm:ss.SSS');
}
const createMockStore = () => {
  let store = {};
  return {
    get: jest.fn().mockImplementation(key => store[key]),
    set: jest.fn().mockImplementation((key, value) => store[key] = value),
    remove: jest.fn().mockImplementation(key => delete store[key]),
    clear: jest.fn().mockImplementation(() => store = {})
  };
};
const mockAppUrls = {
  uptime: '/app/uptime',
  observability: '/app/observability',
  '/home#/tutorial/uptimeMonitors': '/home#/tutorial/uptimeMonitors'
};

/* default mock core */
const defaultCore = exports.defaultCore = _mocks.coreMock.createStart();
const mockCore = () => {
  const core = {
    ...defaultCore,
    application: {
      ...defaultCore.application,
      getUrlForApp: app => mockAppUrls[app],
      navigateToUrl: jest.fn(),
      capabilities: {
        ...defaultCore.application.capabilities,
        uptime: {
          'alerting:save': true,
          configureSettings: true,
          save: true,
          show: true
        },
        actions: {
          save: true
        }
      }
    },
    uiSettings: {
      ...defaultCore.uiSettings,
      get: getSetting,
      get$: setSetting$
    },
    settings: {
      client: {
        ...defaultCore.settings.client,
        get: getSetting,
        get$: setSetting$
      },
      globalClient: defaultCore.settings.globalClient
    },
    usageCollection: {
      reportUiCounter: () => {}
    },
    triggersActionsUi: _mocks2.triggersActionsUiMock.createStart(),
    storage: createMockStore(),
    data: _mocks3.dataPluginMock.createStartContract(),
    // @ts-ignore
    observability: {
      useRulesLink: () => ({
        href: 'newRuleLink'
      }),
      observabilityRuleTypeRegistry: {
        register: jest.fn(),
        getFormatter: jest.fn(),
        list: jest.fn()
      }
    },
    observabilityShared: {
      navigation: {
        // @ts-ignore
        PageTemplate: _sharedUxPageKibanaTemplate.KibanaPageTemplate
      }
    },
    exploratoryView: {
      createExploratoryViewUrl: jest.fn(),
      getAppDataView: jest.fn(),
      ExploratoryViewEmbeddable: () => /*#__PURE__*/_react.default.createElement("div", null, "Embeddable exploratory view")
    },
    unifiedSearch: _mocks4.unifiedSearchPluginMock.createStartContract()
  };
  return core;
};

/* Mock Provider Components */
exports.mockCore = mockCore;
function MockKibanaProvider({
  children,
  core,
  kibanaProps
}) {
  const coreOptions = (0, _lodash.merge)({}, mockCore(), core);
  _kibana_service.kibanaService.core = coreOptions;
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, (0, _extends2.default)({
    services: {
      ...coreOptions
    }
  }, kibanaProps), /*#__PURE__*/_react.default.createElement(_contexts.UptimeRefreshContextProvider, null, /*#__PURE__*/_react.default.createElement(_contexts.UptimeStartupPluginsContextProvider, {
    data: coreOptions.data,
    observability: coreOptions.observability,
    observabilityShared: coreOptions.observabilityShared,
    exploratoryView: coreOptions.exploratoryView
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, children)))));
}
function MockRouter({
  children,
  core,
  path,
  history = (0, _history.createMemoryHistory)(),
  kibanaProps
}) {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(MockKibanaProvider, {
    core: core,
    kibanaProps: kibanaProps
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: path
  }, children)));
}
(0, _react2.configure)({
  testIdAttribute: 'data-test-subj'
});
const MockRedux = ({
  state,
  history = (0, _history.createMemoryHistory)(),
  children,
  path
}) => {
  const testState = {
    ..._uptime_store.mockState,
    ...state
  };
  return /*#__PURE__*/_react.default.createElement(_helper_with_redux.MountWithReduxProvider, {
    state: testState
  }, /*#__PURE__*/_react.default.createElement(MockRouter, {
    path: path,
    history: history
  }, children));
};
exports.MockRedux = MockRedux;
function WrappedHelper({
  children,
  core,
  kibanaProps,
  state,
  url,
  useRealStore,
  path,
  store,
  history = (0, _history.createMemoryHistory)()
}) {
  const testState = (0, _lodash.merge)({}, _uptime_store.mockState, state);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_helper_with_redux.MountWithReduxProvider, {
    state: testState,
    useRealStore: useRealStore,
    store: store
  }, /*#__PURE__*/_react.default.createElement(MockRouter, {
    path: path,
    history: history,
    kibanaProps: kibanaProps,
    core: core
  }, children)));
}

/* Custom react testing library render */
function render(ui, {
  history = (0, _history.createMemoryHistory)(),
  core,
  kibanaProps,
  renderOptions,
  state,
  url,
  path,
  useRealStore,
  store
} = {}) {
  if (url) {
    history = getHistoryFromUrl(url);
  }
  return {
    ...(0, _react2.render)(/*#__PURE__*/_react.default.createElement(WrappedHelper, {
      history: history,
      kibanaProps: kibanaProps,
      core: core,
      url: url,
      state: state,
      path: path,
      useRealStore: useRealStore,
      store: store
    }, ui), renderOptions),
    history
  };
}
const getHistoryFromUrl = url => {
  if (typeof url === 'string') {
    return (0, _history.createMemoryHistory)({
      initialEntries: [url]
    });
  }
  return (0, _history.createMemoryHistory)({
    initialEntries: [url.path + (0, _stringify_url_params.stringifyUrlParams)(url.queryParams)]
  });
};
const forNearestTag = tag => getByText => text => getByText((_content, node) => {
  if (!node) return false;
  const noOtherButtonHasText = Array.from(node.children).every(child => child && (child.textContent !== text || child.tagName.toLowerCase() !== tag));
  return noOtherButtonHasText && node.textContent === text && node.tagName.toLowerCase() === tag;
});

// This function allows us to query for the nearest button with test
// no matter whether it has nested tags or not (as EuiButton elements do).
const forNearestButton = exports.forNearestButton = forNearestTag('button');
const forNearestAnchor = exports.forNearestAnchor = forNearestTag('a');
const makeUptimePermissionsCore = permissions => {
  return {
    application: {
      capabilities: {
        uptime: {
          'alerting:save': true,
          configureSettings: true,
          save: true,
          show: true,
          ...permissions
        }
      }
    }
  };
};
exports.makeUptimePermissionsCore = makeUptimePermissionsCore;