"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _monitor_status_column = require("./monitor_status_column");
var _contexts = require("../../../../contexts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusBadge = ({
  status,
  summaryError
}) => {
  const {
    colors: {
      dangerBehindText
    }
  } = (0, _react.useContext)(_contexts.UptimeThemeContext);
  if (status === _constants.STATUS.UP) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      className: "eui-textCenter",
      color: 'success'
    }, (0, _monitor_status_column.getHealthMessage)(status));
  }
  const errorMessage = summaryError === null || summaryError === void 0 ? void 0 : summaryError.message;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: errorMessage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "eui-textCenter",
    color: dangerBehindText
  }, (0, _monitor_status_column.getHealthMessage)(status)));
};
exports.StatusBadge = StatusBadge;