"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocationStatusTags = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _contexts = require("../../../../contexts");
var _constants = require("../../../../../../common/constants");
var _ = require("..");
var _monitor_status_column = require("../../../overview/monitor_list/columns/monitor_status_column");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Set height so that it remains within panel, enough height to display 7 locations tags
const TagContainer = _styledComponents.default.div`
  max-height: 246px;
  overflow: hidden;
`;
const LocationStatusTags = ({
  locations
}) => {
  var _moment$locale;
  const {
    colors: {
      gray,
      danger
    }
  } = (0, _react.useContext)(_contexts.UptimeThemeContext);
  const allLocations = [];
  const prevLocal = (_moment$locale = _moment.default.locale()) !== null && _moment$locale !== void 0 ? _moment$locale : 'en';
  const shortLocale = _moment.default.locale(_constants.SHORT_TS_LOCALE) === _constants.SHORT_TS_LOCALE;
  if (!shortLocale) {
    _moment.default.defineLocale(_constants.SHORT_TS_LOCALE, _constants.SHORT_TIMESPAN_LOCALE);
  }
  locations.forEach(item => {
    allLocations.push({
      label: item.geo.name,
      timestamp: (0, _monitor_status_column.getShortTimeStamp)((0, _moment.default)(new Date(item.timestamp).valueOf())),
      color: item.summary.down === 0 ? gray : danger,
      availability: item.up_history / (item.up_history + item.down_history) * 100,
      status: item.summary.down === 0 ? 'up' : 'down'
    });
  });

  // Need to reset locale so it doesn't effect other parts of the app
  _moment.default.locale(prevLocal);

  // Sort lexicographically by label
  allLocations.sort((a, b) => {
    return a.label > b.label ? 1 : b.label > a.label ? -1 : 0;
  });
  if (allLocations.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TagContainer, null, /*#__PURE__*/_react.default.createElement(_.AvailabilityReporting, {
    allLocations: allLocations
  })));
};
exports.LocationStatusTags = LocationStatusTags;