"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.matchAutoResolutionPattern = exports.defaultAutoResolution = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultAutoResolution = exports.defaultAutoResolution = {
  'apm-7.*': 'readOnly'
};
const matchAutoResolutionPattern = indexName => {
  const result = Object.entries(defaultAutoResolution).find(([excludedPattern]) => {
    const isPattern = /.+\*$/.test(excludedPattern);
    if (isPattern) {
      const matcher = excludedPattern.slice(0, -1);
      return indexName.startsWith(matcher);
    }
    return indexName === excludedPattern;
  });
  if (!result) {
    return null;
  }
  return result[1];
};
exports.matchAutoResolutionPattern = matchAutoResolutionPattern;