"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Trace = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fields = require("../doc_viewer_span_overview/resources/fields");
var _fields2 = require("../doc_viewer_transaction_overview/resources/fields");
var _span_summary_field = require("../doc_viewer_span_overview/sub_components/span_summary_field");
var _transaction_summary_field = require("../doc_viewer_transaction_overview/sub_components/transaction_summary_field");
var _plugin = require("../../../../plugin");
var _full_screen_waterfall = require("./full_screen_waterfall");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const Trace = ({
  traceId,
  fields,
  fieldMappings,
  displayType,
  docId,
  dataView,
  tracesIndexPattern,
  showWaterfall = true,
  showActions = true
}) => {
  const {
    data
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const [showFullScreenWaterfall, setShowFullScreenWaterfall] = (0, _react.useState)(false);
  const {
    from: rangeFrom,
    to: rangeTo
  } = data.query.timefilter.timefilter.getAbsoluteTime();
  const getParentApi = (0, _react.useCallback)(() => ({
    getSerializedStateForChild: () => ({
      rawState: {
        traceId,
        rangeFrom,
        rangeTo,
        docId
      }
    })
  }), [docId, rangeFrom, rangeTo, traceId]);
  const fieldRows = displayType === 'span' ? _fields.spanTraceFields.map(fieldId => /*#__PURE__*/_react.default.createElement(_span_summary_field.SpanSummaryField, {
    key: fieldId,
    fieldId: fieldId,
    fieldConfiguration: fields[fieldId],
    fieldMapping: fieldMappings[fieldId],
    showActions: showActions
  })) : _fields2.transactionTraceFields.map(fieldId => /*#__PURE__*/_react.default.createElement(_transaction_summary_field.TransactionSummaryField, {
    key: fieldId,
    fieldId: fieldId,
    fieldConfiguration: fields[fieldId],
    fieldMapping: fieldMappings[fieldId],
    showActions: showActions
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showFullScreenWaterfall && /*#__PURE__*/_react.default.createElement(_full_screen_waterfall.FullScreenWaterfall, {
    traceId: traceId,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    dataView: dataView,
    tracesIndexPattern: tracesIndexPattern,
    onExitFullScreen: () => {
      setShowFullScreenWaterfall(false);
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('unifiedDocViewer.observability.traces.trace.title', {
    defaultMessage: 'Trace'
  })))), showWaterfall && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "unifiedDocViewerObservabilityTracesTraceFullScreenButton",
    iconSize: "m",
    iconType: "fullScreen",
    color: "text",
    "aria-label": _i18n.i18n.translate('unifiedDocViewer.observability.traces.trace.fullScreen.button', {
      defaultMessage: 'Open full screen waterfall'
    }),
    onClick: () => {
      setShowFullScreenWaterfall(true);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, fieldRows)), showWaterfall && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.EmbeddableRenderer, {
    type: "APM_TRACE_WATERFALL_EMBEDDABLE",
    getParentApi: getParentApi,
    hidePanelChrome: true
  })));
};
exports.Trace = Trace;