"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FLYOUT_WIDTH_KEY = void 0;
exports.UnifiedDocViewerFlyout = UnifiedDocViewerFlyout;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _lazy_doc_viewer = require("../lazy_doc_viewer");
var _use_flyout_a11y = require("./use_flyout_a11y");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getIndexByDocId(hits, id) {
  return hits.findIndex(h => {
    return h.id === id;
  });
}
const FLYOUT_WIDTH_KEY = exports.FLYOUT_WIDTH_KEY = 'unifiedDocViewer:flyoutWidth';

/**
 * Flyout displaying an expanded row details
 */
function UnifiedDocViewerFlyout({
  docViewerRef,
  'data-test-subj': dataTestSubj,
  flyoutTitle,
  flyoutActions,
  flyoutDefaultWidth,
  flyoutType,
  flyoutWidthLocalStorageKey,
  FlyoutCustomBody,
  services,
  docViewsRegistry,
  isEsqlQuery,
  hit,
  hits,
  dataView,
  columns,
  columnsMeta,
  onFilter,
  onClose,
  onRemoveColumn,
  onAddColumn,
  setExpandedDoc,
  initialTabId
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isXlScreen = (0, _eui.useIsWithinMinBreakpoint)('xl');
  const DEFAULT_WIDTH = euiTheme.base * 34;
  const defaultWidth = flyoutDefaultWidth !== null && flyoutDefaultWidth !== void 0 ? flyoutDefaultWidth : DEFAULT_WIDTH; // Give enough room to search bar to not wrap
  const [flyoutWidth, setFlyoutWidth] = (0, _useLocalStorage.default)(flyoutWidthLocalStorageKey !== null && flyoutWidthLocalStorageKey !== void 0 ? flyoutWidthLocalStorageKey : FLYOUT_WIDTH_KEY, defaultWidth);
  const minWidth = euiTheme.base * 24;
  const maxWidth = euiTheme.breakpoint.xl;
  // Get actual hit with updated highlighted searches
  const actualHit = (0, _react.useMemo)(() => (hits === null || hits === void 0 ? void 0 : hits.find(({
    id
  }) => id === (hit === null || hit === void 0 ? void 0 : hit.id))) || hit, [hit, hits]);
  const pageCount = (0, _react.useMemo)(() => hits ? hits.length : 0, [hits]);
  const activePage = (0, _react.useMemo)(() => {
    const id = hit.id;
    if (!hits || pageCount <= 1) {
      return -1;
    }
    return getIndexByDocId(hits, id);
  }, [hits, hit, pageCount]);
  const setPage = (0, _react.useCallback)(index => {
    if (hits && hits[index]) {
      setExpandedDoc(hits[index]);
    }
  }, [hits, setExpandedDoc]);
  const onKeyDown = (0, _react.useCallback)(ev => {
    if (ev.target instanceof HTMLElement && ev.target.closest('.euiDataGrid__content')) {
      // ignore events triggered from the data grid
      return;
    }
    if (ev.key === _eui.keys.ESCAPE) {
      ev.preventDefault();
      ev.stopPropagation();
      onClose();
    }
    if (ev.target instanceof HTMLInputElement) {
      // ignore events triggered from the search input
      return;
    }
    const isTabButton = ev.target.getAttribute('role') === 'tab';
    if (isTabButton) {
      // ignore events triggered when the tab buttons are focused
      return;
    }
    const isResizableButton = ev.target.getAttribute('data-test-subj') === 'euiResizableButton';
    if (isResizableButton) {
      // ignore events triggered when the resizable button is focused
      return;
    }
    if (ev.key === _eui.keys.ARROW_LEFT || ev.key === _eui.keys.ARROW_RIGHT) {
      ev.preventDefault();
      ev.stopPropagation();
      setPage(activePage + (ev.key === _eui.keys.ARROW_RIGHT ? 1 : -1));
    }
  }, [activePage, onClose, setPage]);
  const addColumn = (0, _react.useCallback)(columnName => {
    var _services$toastNotifi;
    onAddColumn(columnName);
    (_services$toastNotifi = services.toastNotifications) === null || _services$toastNotifi === void 0 ? void 0 : _services$toastNotifi.addSuccess(_i18n.i18n.translate('unifiedDocViewer.flyout.toastColumnAdded', {
      defaultMessage: `Column ''{columnName}'' was added`,
      values: {
        columnName
      }
    }));
  }, [onAddColumn, services.toastNotifications]);
  const removeColumn = (0, _react.useCallback)(columnName => {
    var _services$toastNotifi2;
    onRemoveColumn(columnName);
    (_services$toastNotifi2 = services.toastNotifications) === null || _services$toastNotifi2 === void 0 ? void 0 : _services$toastNotifi2.addSuccess(_i18n.i18n.translate('unifiedDocViewer.flyout.toastColumnRemoved', {
      defaultMessage: `Column ''{columnName}'' was removed`,
      values: {
        columnName
      }
    }));
  }, [onRemoveColumn, services.toastNotifications]);
  const renderDefaultContent = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_lazy_doc_viewer.UnifiedDocViewer, {
    ref: docViewerRef,
    columns: columns,
    columnsMeta: columnsMeta,
    dataView: dataView,
    filter: onFilter,
    hit: actualHit,
    onAddColumn: addColumn,
    onRemoveColumn: removeColumn,
    textBasedHits: isEsqlQuery ? hits : undefined,
    docViewsRegistry: docViewsRegistry,
    decreaseAvailableHeightBy: 80 // flyout footer height
    ,
    initialTabId: initialTabId
  }), [docViewerRef, columns, columnsMeta, dataView, onFilter, actualHit, addColumn, removeColumn, isEsqlQuery, hits, docViewsRegistry, initialTabId]);
  const contentActions = (0, _react.useMemo)(() => ({
    filter: onFilter,
    onAddColumn: addColumn,
    onRemoveColumn: removeColumn
  }), [onFilter, addColumn, removeColumn]);
  const bodyContent = FlyoutCustomBody ? /*#__PURE__*/_react.default.createElement(FlyoutCustomBody, {
    actions: contentActions,
    doc: actualHit,
    renderDefaultContent: renderDefaultContent
  }) : renderDefaultContent();
  const defaultFlyoutTitle = isEsqlQuery ? _i18n.i18n.translate('unifiedDocViewer.flyout.docViewerEsqlDetailHeading', {
    defaultMessage: 'Result'
  }) : _i18n.i18n.translate('unifiedDocViewer.flyout.docViewerDetailHeading', {
    defaultMessage: 'Document'
  });
  const currentFlyoutTitle = flyoutTitle !== null && flyoutTitle !== void 0 ? flyoutTitle : defaultFlyoutTitle;
  const {
    a11yProps,
    screenReaderDescription
  } = (0, _use_flyout_a11y.useFlyoutA11y)({
    isXlScreen
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, (0, _extends2.default)({
    className: "DiscoverFlyout" // used to override the z-index of the flyout from SecuritySolution
    ,
    onClose: onClose,
    type: flyoutType !== null && flyoutType !== void 0 ? flyoutType : 'push',
    size: flyoutWidth,
    pushMinBreakpoint: "xl",
    "data-test-subj": dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'docViewerFlyout',
    onKeyDown: onKeyDown,
    ownFocus: true,
    minWidth: minWidth,
    maxWidth: maxWidth,
    onResize: setFlyoutWidth,
    css: {
      maxWidth: `${isXlScreen ? `calc(100vw - ${DEFAULT_WIDTH}px)` : '90vw'} !important`
    },
    paddingSize: "m"
  }, a11yProps), screenReaderDescription, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "m",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "docViewerRowDetailsTitle",
    css: (0, _react2.css)`
                  white-space: nowrap;
                `
  }, /*#__PURE__*/_react.default.createElement("h2", null, currentFlyoutTitle))), activePage !== -1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `docViewerFlyoutNavigationPage-${activePage}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('unifiedDocViewer.flyout.documentNavigation', {
      defaultMessage: 'Document navigation'
    }),
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: setPage,
    compressed: true,
    "data-test-subj": "docViewerFlyoutNavigation"
  }))), isEsqlQuery || !flyoutActions ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), flyoutActions)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, bodyContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    "data-test-subj": "docViewerFlyoutCloseButton"
  }, _i18n.i18n.translate('unifiedDocViewer.flyout.closeButtonLabel', {
    defaultMessage: 'Close'
  })))));
}