"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatRuleAlertCount = void 0;
var _lt = _interopRequireDefault(require("semver/functions/lt"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatRuleAlertCount = (value, version) => {
  if (version) {
    try {
      const intValue = parseInt(value, 10);
      if (intValue === 0 && (0, _lt.default)(version, '8.3.0')) {
        return '--';
      }
    } catch (err) {
      return value;
    }
  }
  return value;
};
exports.formatRuleAlertCount = formatRuleAlertCount;