"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseSnoozePanel = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../../../../../common");
var _constants = require("./constants");
var _helpers = require("./helpers");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BaseSnoozePanel = ({
  isLoading,
  interval = '3d',
  snoozeRule,
  unsnoozeRule,
  showCancel,
  showAddSchedule = true,
  scheduledSnoozes,
  activeSnoozes,
  navigateToScheduler,
  onRemoveAllSchedules,
  hasTitle,
  inPopover = false
}) => {
  const [intervalValue, setIntervalValue] = (0, _react.useState)((0, _common.parseInterval)(interval).value);
  const [intervalUnit, setIntervalUnit] = (0, _react.useState)((0, _common.parseInterval)(interval).unit);
  const [isRemoveAllModalVisible, setIsRemoveAllModalVisible] = (0, _react.useState)(false);
  const [isCancelModalVisible, setIsCancelModalVisible] = (0, _react.useState)(false);
  const [previousSnoozeInterval, setPreviousSnoozeInterval] = (0, _helpers.usePreviousSnoozeInterval)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onChangeValue = (0, _react.useCallback)(({
    target
  }) => {
    const value = Number(target.value);
    if (!isNaN(value)) {
      setIntervalValue(value);
    }
  }, [setIntervalValue]);
  const onChangeUnit = (0, _react.useCallback)(({
    target
  }) => setIntervalUnit(target.value), [setIntervalUnit]);
  const snoozeRuleAndStoreInterval = (0, _react.useCallback)((newSnoozeEndTime, intervalToStore) => {
    if (intervalToStore) {
      if (intervalToStore.startsWith('-')) throw new Error('Cannot store a negative interval');
      setPreviousSnoozeInterval(intervalToStore);
    }
    const newSnoozeSchedule = {
      id: null,
      duration: newSnoozeEndTime === -1 ? -1 : Date.parse(newSnoozeEndTime) - Date.now(),
      rRule: {
        dtstart: new Date().toISOString(),
        count: 1,
        tzid: _moment.default.tz.guess()
      }
    };
    return snoozeRule(newSnoozeSchedule);
  }, [setPreviousSnoozeInterval, snoozeRule]);
  const applySnooze = (0, _react.useCallback)(async (value, unit) => {
    if (value === -1) {
      await snoozeRuleAndStoreInterval(-1, null);
    } else if (value !== 0) {
      const newSnoozeEndTime = (0, _moment.default)().add(value, unit).toISOString();
      await snoozeRuleAndStoreInterval(newSnoozeEndTime, `${value}${unit}`);
    } else await unsnoozeRule();
  }, [snoozeRuleAndStoreInterval, unsnoozeRule]);
  const onApplyIndefinite = (0, _react.useCallback)(() => applySnooze(-1), [applySnooze]);
  const onClickApplyButton = (0, _react.useCallback)(() => applySnooze(intervalValue, intervalUnit), [applySnooze, intervalValue, intervalUnit]);
  const onCancelSnooze = (0, _react.useCallback)(() => {
    applySnooze(0, 'm');
    setIsCancelModalVisible(false);
  }, [applySnooze, setIsCancelModalVisible]);
  const onClickCancelSnooze = (0, _react.useCallback)(() => {
    if (activeSnoozes.length === 0) onCancelSnooze();else setIsCancelModalVisible(true);
  }, [activeSnoozes, setIsCancelModalVisible, onCancelSnooze]);
  const onClickAddSchedule = (0, _react.useCallback)(() => navigateToScheduler(), [navigateToScheduler]);
  const onClickEditScheduleFactory = (0, _react.useCallback)(schedule => () => navigateToScheduler(schedule), [navigateToScheduler]);
  const onClickRemoveAllSchedules = (0, _react.useCallback)(() => {
    setIsRemoveAllModalVisible(false);
    onRemoveAllSchedules(scheduledSnoozes.filter(s => s.id).map(s => s.id));
  }, [onRemoveAllSchedules, scheduledSnoozes]);
  const numberOfSchedules = (0, _react.useMemo)(() => {
    if (!scheduledSnoozes) {
      return 0;
    }
    return scheduledSnoozes.filter(s => Boolean(s.id)).length;
  }, [scheduledSnoozes]);
  const hasSchedules = (0, _react.useMemo)(() => numberOfSchedules > 0, [numberOfSchedules]);
  const renderSchedule = () => {
    if (!showAddSchedule) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s"
    }), !hasSchedules && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      color: "primary",
      onClick: onClickAddSchedule,
      "data-test-subj": "ruleAddSchedule",
      iconType: "calendar"
    }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.addSchedule', {
      defaultMessage: 'Add schedule'
    }))))), hasSchedules && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeSchedulesTitle', {
      defaultMessage: 'Schedules'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "danger",
      size: "xs",
      onClick: () => setIsRemoveAllModalVisible(true),
      "data-test-subj": "ruleRemoveAllSchedules"
    }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.removeAllButton', {
      defaultMessage: 'Remove all'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs",
      "data-test-subj": "ruleSchedulesList"
    }, scheduledSnoozes.filter(s => s.id).map(schedule => {
      const isActive = schedule.id && activeSnoozes.includes(schedule.id);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: `snooze-${schedule.id}`
      }, /*#__PURE__*/_react.default.createElement("button", {
        style: {
          paddingLeft: '9px',
          paddingRight: '9px',
          height: '36px',
          // Replicate euiPanel--accent vs euiPanel--subdued
          // Applying these classNames by themselves doesn't work due to a CSS-in-JS issue with EuiPanel
          color: isActive ? '#a8376a' : euiTheme.colors.subduedText,
          backgroundColor: isActive ? 'rgba(240,78,152,0.2)' : euiTheme.colors.body
        },
        className: "euiButton euiPanel euiPanel--borderRadiusMedium euiPanel--noShadow euiPanel--noBorder",
        onClick: onClickEditScheduleFactory(schedule)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: isActive ? 'bellSlash' : 'calendar'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          textAlign: 'left'
        }
      }, (0, _helpers.scheduleSummary)(schedule)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "arrowRight"
      })))));
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      isDisabled: numberOfSchedules >= 5,
      "data-test-subj": "ruleSchedulesListAddButton",
      iconType: "plusInCircleFilled",
      onClick: onClickAddSchedule
    }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.addButton', {
      defaultMessage: 'Add'
    }))))));
  };
  const parsedPrevSnooze = previousSnoozeInterval ? (0, _common.parseInterval)(previousSnoozeInterval) : null;
  const prevSnoozeEqualsCurrentSnooze = (parsedPrevSnooze === null || parsedPrevSnooze === void 0 ? void 0 : parsedPrevSnooze.value) === intervalValue && (parsedPrevSnooze === null || parsedPrevSnooze === void 0 ? void 0 : parsedPrevSnooze.unit) === intervalUnit;
  const previousButton = parsedPrevSnooze && !prevSnoozeEqualsCurrentSnooze && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    iconType: "refresh",
    "data-test-subj": "ruleSnoozePreviousButton",
    onClick: () => applySnooze(parsedPrevSnooze.value, parsedPrevSnooze.unit)
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.previousSnooze', {
    defaultMessage: 'Previous'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": "ruleSnoozePreviousText"
  }, (0, _helpers.durationToTextString)(parsedPrevSnooze.value, parsedPrevSnooze.unit)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    "data-test-subj": "snoozePanelTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "bellSlash"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozePanelTitle', {
    defaultMessage: 'Snooze notifications'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "left",
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.addScheduleDescription', {
    defaultMessage: 'Silence actions immediately or schedule downtimes.'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "snoozePanel",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    min: 1,
    value: intervalValue,
    onChange: onChangeValue,
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozePanelIntervalValueLabel', {
      defaultMessage: 'Snooze interval value'
    }),
    "data-test-subj": "ruleSnoozeIntervalValue"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: (0, _eui.useGeneratedHtmlId)({
      prefix: 'snoozeUnit'
    }),
    value: intervalUnit,
    onChange: onChangeUnit,
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozePanelIntervalUnitLabel', {
      defaultMessage: 'Snooze interval unit'
    }),
    options: [{
      value: 'm',
      text: _translations.MINUTES
    }, {
      value: 'h',
      text: _translations.HOURS
    }, {
      value: 'd',
      text: _translations.DAYS
    }, {
      value: 'w',
      text: _translations.WEEKS
    }, {
      value: 'M',
      text: _translations.MONTHS
    }],
    "data-test-subj": "ruleSnoozeIntervalUnit"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !intervalValue || intervalValue < 1,
    isLoading: isLoading,
    onClick: onClickApplyButton,
    "data-test-subj": "ruleSnoozeApply",
    minWidth: 0
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.applySnooze', {
    defaultMessage: 'Apply'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), previousButton, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeCommonlyUsed', {
    defaultMessage: 'Commonly used'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), _constants.COMMON_SNOOZE_TIMES.map(([value, unit]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `snooze-${value}${unit}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `linkSnooze${value}${unit}`,
    onClick: () => applySnooze(value, unit)
  }, (0, _helpers.durationToTextString)(value, unit))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    onClick: onApplyIndefinite,
    "data-test-subj": "ruleSnoozeIndefiniteApply"
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeIndefinitely', {
    defaultMessage: 'Snooze indefinitely'
  })))), renderSchedule(), showCancel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !inPopover && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, !inPopover && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    color: "danger",
    onClick: onClickCancelSnooze,
    "data-test-subj": "ruleSnoozeCancel"
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.cancelSnooze', {
    defaultMessage: 'Cancel snooze'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), isRemoveAllModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.removeAllSnoozeSchedules",
      defaultMessage: "Remove {count, plural, one {schedule} other {# schedules}}?",
      values: {
        count: scheduledSnoozes.filter(s => s.id).length
      }
    }),
    onCancel: () => setIsRemoveAllModalVisible(false),
    onConfirm: onClickRemoveAllSchedules,
    buttonColor: "danger",
    cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.removeCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.removeConfirmButton', {
      defaultMessage: 'Remove'
    })
  }), isCancelModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.cancelSnooze', {
      defaultMessage: 'Cancel snooze'
    }),
    style: {
      maxWidth: '420px'
    },
    onCancel: () => setIsCancelModalVisible(false),
    onConfirm: onCancelSnooze,
    cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.dontApplyCancelSnoozeButton', {
      defaultMessage: "Don't apply"
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.applyCancelSnoozeButton', {
      defaultMessage: 'Apply'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.cancelSnoozeConfirmText', {
    defaultMessage: 'Resume notifying when alerts are generated as defined in the rule actions.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    size: "s",
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.cancelSnoozeConfirmCallout', {
      defaultMessage: 'Only the current occurrence of a schedule will be cancelled.'
    })
  })));
};
exports.BaseSnoozePanel = BaseSnoozePanel;