"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdatedTransformConfig = void 0;
var _react = require("react");
var _toolkit = require("@reduxjs/toolkit");
var _reactRedux = require("react-redux");
var _apply_form_state_to_transform_config = require("../apply_form_state_to_transform_config");
var _edit_transform_flyout_state = require("../edit_transform_flyout_state");
var _form_field = require("./form_field");
var _form_sections = require("./form_sections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSelectTransformConfig = originalConfig => (0, _toolkit.createSelector)(_form_field.selectFormFields, _form_sections.selectFormSections, (formFields, formSections) => (0, _apply_form_state_to_transform_config.applyFormStateToTransformConfig)(originalConfig, formFields, formSections));
const useUpdatedTransformConfig = () => {
  const {
    config
  } = (0, _edit_transform_flyout_state.useEditTransformFlyoutContext)();
  const selectTransformConfig = (0, _react.useMemo)(() => createSelectTransformConfig(config), [config]);
  return (0, _reactRedux.useSelector)(selectTransformConfig);
};
exports.useUpdatedTransformConfig = useUpdatedTransformConfig;