"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isJsonString = isJsonString;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Validates whether string input can be parsed as a valid JSON
 * @param value User input value.
 */
function isJsonString(value) {
  if (typeof value !== 'string') return false;
  try {
    return !!JSON.parse(value);
  } catch (e) {
    return false;
  }
}