"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IndicatorsPageWrapper = exports.APP_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@kbn/react-query");
var _indicators = require("../modules/indicators/pages/indicators");
var _integrations_guard = require("./integrations_guard");
var _security_solution_plugin_template_wrapper = require("./security_solution_plugin_template_wrapper");
var _use_kibana = require("../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APP_ID = exports.APP_ID = 'securitySolution';
const queryClient = new _reactQuery.QueryClient();
const casesContextOwner = [APP_ID];
const IndicatorsPageWrapper = () => {
  const {
    cases
  } = (0, _use_kibana.useKibana)().services;
  const CasesContext = (0, _react.useMemo)(() => cases.ui.getCasesContext(), [cases.ui]);
  const permissions = (0, _react.useMemo)(() => cases.helpers.canUseCases(), [cases.helpers]);
  return /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: casesContextOwner,
    permissions: permissions
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_integrations_guard.IntegrationsGuard, null, /*#__PURE__*/_react.default.createElement(_security_solution_plugin_template_wrapper.SecuritySolutionPluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_indicators.IndicatorsPage, null)))));
};

// Note: This is for lazy loading
// eslint-disable-next-line import/no-default-export
exports.IndicatorsPageWrapper = IndicatorsPageWrapper;
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(IndicatorsPageWrapper);