"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLocationMonitors = void 0;
var _constants = require("@kbn/spaces-plugin/common/constants");
var _get_private_locations = require("./get_private_locations");
var _constants2 = require("../../../../common/constants");
var _saved_objects = require("../../../../common/types/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const aggs = {
  locations_legacy: {
    terms: {
      field: `${_saved_objects.legacyMonitorAttributes}.locations.id`,
      size: 20000
    }
  },
  locations: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorAttributes}.locations.id`,
      size: 20000
    }
  }
};
const getLocationMonitors = () => ({
  method: 'GET',
  path: _constants2.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS_MONITORS,
  validate: {},
  handler: async ({
    server,
    savedObjectsClient,
    syntheticsMonitorClient
  }) => {
    var _aggsResp$locations_l, _aggsResp$locations;
    const soClient = server.coreStart.savedObjects.createInternalRepository();
    const {
      locations
    } = await (0, _get_private_locations.getPrivateLocationsAndAgentPolicies)(savedObjectsClient, syntheticsMonitorClient);
    const locationMonitors = await soClient.find({
      type: _saved_objects.syntheticsMonitorSOTypes,
      perPage: 0,
      aggs,
      namespaces: [_constants.ALL_SPACES_ID]
    });
    const aggsResp = locationMonitors.aggregations;

    // Merge counts from both buckets
    const counts = {};
    aggsResp === null || aggsResp === void 0 ? void 0 : (_aggsResp$locations_l = aggsResp.locations_legacy) === null || _aggsResp$locations_l === void 0 ? void 0 : _aggsResp$locations_l.buckets.forEach(({
      key,
      doc_count: docCount
    }) => {
      counts[key] = (counts[key] || 0) + docCount;
    });
    aggsResp === null || aggsResp === void 0 ? void 0 : (_aggsResp$locations = aggsResp.locations) === null || _aggsResp$locations === void 0 ? void 0 : _aggsResp$locations.buckets.forEach(({
      key,
      doc_count: docCount
    }) => {
      counts[key] = (counts[key] || 0) + docCount;
    });
    return Object.entries(counts).map(([id, count]) => ({
      id,
      count
    })).filter(({
      id
    }) => locations.some(location => location.id === id || location.label === id));
  }
});
exports.getLocationMonitors = getLocationMonitors;