"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatestTestRun = getLatestTestRun;
var _client_defaults = require("../../common/constants/client_defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLatestTestRun({
  syntheticsEsClient,
  monitorId,
  locationLabel,
  from = 'now-1d',
  to = 'now'
}) {
  var _response$body$hits$h;
  const response = await syntheticsEsClient.search({
    body: {
      query: {
        bool: {
          filter: [_client_defaults.SUMMARY_FILTER, (0, _client_defaults.getRangeFilter)({
            from,
            to
          }), {
            term: {
              'monitor.id': monitorId
            }
          }, ...(locationLabel ? [{
            term: {
              'observer.geo.name': locationLabel
            }
          }] : [])]
        }
      },
      sort: [{
        '@timestamp': {
          order: 'desc'
        }
      }]
    }
  });
  return (_response$body$hits$h = response.body.hits.hits[0]) === null || _response$body$hits$h === void 0 ? void 0 : _response$body$hits$h._source;
}