"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageRouter = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRouterDom = require("react-router-dom");
var _reactReversePortal = require("react-reverse-portal");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _sharedUxPromptNotFound = require("@kbn/shared-ux-prompt-not-found");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _certificate_title = require("./components/certificates/certificate_title");
var _cert_refresh_btn = require("./components/certificates/cert_refresh_btn");
var _use_synthetics_priviliges = require("./hooks/use_synthetics_priviliges");
var _route_config = require("./components/monitors_page/route_config");
var _synthetics_page_template = require("./components/common/page_template/synthetics_page_template");
var _route_config2 = require("./components/monitor_details/route_config");
var _route_config3 = require("./components/step_details_page/route_config");
var _route_config4 = require("./components/test_run_details/route_config");
var _route_config5 = require("./components/settings/route_config");
var _test_run_details = require("./components/test_run_details/test_run_details");
var _monitor_add_page = require("./components/monitor_add_edit/monitor_add_page");
var _monitor_edit_page = require("./components/monitor_add_edit/monitor_edit_page");
var _getting_started_page = require("./components/getting_started/getting_started_page");
var _portals = require("./components/monitor_add_edit/portals");
var _constants = require("../../../common/constants");
var _plugin = require("../../../common/constants/plugin");
var _api_service = require("../../utils/api_service");
var _route_config6 = require("./components/error_details/route_config");
var _certificates = require("./components/certificates/certificates");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const baseTitle = _i18n.i18n.translate('xpack.synthetics.routes.baseTitle', {
  defaultMessage: 'Synthetics - Kibana'
});
const getRoutes = (euiTheme, history, location, syntheticsPath) => {
  return [...(0, _route_config5.getSettingsRouteConfig)(history, syntheticsPath, baseTitle), (0, _route_config6.getErrorDetailsRouteConfig)(history, syntheticsPath, baseTitle), (0, _route_config4.getTestRunDetailsRoute)(history, syntheticsPath, baseTitle), (0, _route_config3.getStepDetailsRoute)(history, syntheticsPath, baseTitle), ...(0, _route_config2.getMonitorDetailsRoute)(history, syntheticsPath, baseTitle), ...(0, _route_config.getMonitorsRoute)(history, location, syntheticsPath, baseTitle), {
    title: _i18n.i18n.translate('xpack.synthetics.gettingStartedRoute.title', {
      defaultMessage: 'Synthetics Getting Started | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.GETTING_STARTED_ROUTE,
    component: _getting_started_page.GettingStartedPage,
    dataTestSubj: 'syntheticsGettingStartedPage',
    pageSectionProps: {
      alignment: 'center',
      paddingSize: 'none'
    }
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.createMonitorRoute.title', {
      defaultMessage: 'Create Monitor | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_ADD_ROUTE,
    component: _monitor_add_page.MonitorAddPage,
    dataTestSubj: 'syntheticsMonitorAddPage',
    restrictWidth: true,
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.createMonitor.pageHeader.title",
        defaultMessage: "Create Monitor"
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
        node: _portals.InspectMonitorPortalNode
      })]
    }
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.editMonitorRoute.title', {
      defaultMessage: 'Edit Monitor | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_EDIT_ROUTE,
    component: _monitor_edit_page.MonitorEditPage,
    dataTestSubj: 'syntheticsMonitorEditPage',
    restrictWidth: true,
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.editMonitor.pageHeader.title",
        defaultMessage: "Edit Monitor"
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
        node: _portals.MonitorTypePortalNode
      }), /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
        node: _portals.InspectMonitorPortalNode
      })],
      breadcrumbs: [{
        text: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
          node: _portals.MonitorDetailsLinkPortalNode
        })
      }]
    }
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.testRunDetailsRoute.title', {
      defaultMessage: 'Test run details | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.TEST_RUN_DETAILS_ROUTE,
    component: _test_run_details.TestRunDetails,
    dataTestSubj: 'syntheticsMonitorTestRunDetailsPage',
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.testRunDetailsRoute.page.title",
        defaultMessage: "Test run details"
      })
    }
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.certificatesRoute.title', {
      defaultMessage: `Certificates | {baseTitle}`,
      values: {
        baseTitle
      }
    }),
    path: _constants.CERTIFICATES_ROUTE,
    component: _certificates.CertificatesPage,
    dataTestSubj: 'uptimeCertificatesPage',
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_certificate_title.CertificateTitle, null),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_cert_refresh_btn.CertRefreshBtn, null)]
    }
  }];
};
const RouteInit = ({
  path,
  title
}) => {
  (0, _react.useEffect)(() => {
    document.title = title;
  }, [path, title]);
  return null;
};
const PageRouter = () => {
  const {
    application
  } = (0, _public2.useKibana)().services;
  const {
    addInspectorRequest
  } = (0, _public3.useInspectorContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const routes = getRoutes(euiTheme, history, location, application.getUrlForApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID));
  _api_service.apiService.addInspectorRequest = addInspectorRequest;
  const isUnprivileged = (0, _use_synthetics_priviliges.useSyntheticsPrivileges)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    enableExecutionContextTracking: true
  }, routes.map(({
    title,
    path,
    component: RouteComponent,
    dataTestSubj,
    pageHeader,
    ...pageTemplateProps
  }) => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: path,
    key: dataTestSubj,
    exact: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(RouteInit, {
    title: title,
    path: path
  }), /*#__PURE__*/_react.default.createElement(_synthetics_page_template.SyntheticsPageTemplateComponent, (0, _extends2.default)({
    pageHeader: isUnprivileged ? undefined : pageHeader,
    "data-test-subj": 'synthetics-page-template',
    isPageDataLoaded: true
  }, pageTemplateProps), isUnprivileged || /*#__PURE__*/_react.default.createElement(RouteComponent, null))))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: () => /*#__PURE__*/_react.default.createElement(_synthetics_page_template.SyntheticsPageTemplateComponent, null, /*#__PURE__*/_react.default.createElement(_sharedUxPromptNotFound.NotFoundPrompt, {
      actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "syntheticsPageRouterGoToSyntheticsHomePageButton",
        iconType: "arrowLeft",
        flush: "both",
        onClick: () => {
          application.navigateToApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID);
        }
      }, _i18n.i18n.translate('xpack.synthetics.routes.goToSynthetics', {
        defaultMessage: 'Go to Synthetics Home Page'
      }))]
    }))
  }));
};
exports.PageRouter = PageRouter;