"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDetails = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _step_number_nav = require("./step_number_nav");
var _step_screenshot_details = require("../step_screenshot_details");
var _step_tabs = require("../step_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepDetails = ({
  step,
  loading,
  stepIndex,
  stepsData,
  totalSteps,
  setStepIndex
}) => {
  if (totalSteps === 0 && !loading) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.testDetail.totalSteps",
    defaultMessage: "Step {stepIndex} of {totalSteps}",
    values: {
      stepIndex,
      totalSteps
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_step_number_nav.StepNumberNav, {
    stepIndex: stepIndex,
    totalSteps: totalSteps,
    handleNextStep: () => {
      setStepIndex(stepIndex + 1);
    },
    handlePreviousStep: () => {
      setStepIndex(stepIndex - 1);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_step_screenshot_details.StepScreenshotDetails, {
    stepIndex: stepIndex,
    step: step
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_step_tabs.StepTabs, {
    stepsList: stepsData === null || stepsData === void 0 ? void 0 : stepsData.steps,
    step: step,
    loading: loading
  }));
};
exports.StepDetails = StepDetails;