"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetIlmPolicies = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _use_object_metrics = require("../../step_details_page/hooks/use_object_metrics");
var _common = require("../data_retention/common");
var _policy_labels = require("../data_retention/policy_labels");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetIlmPolicies = () => {
  var _data$filter;
  const {
    data,
    error,
    loading
  } = (0, _public.useFetcher)(async () => {
    return (0, _api.getIlmPolicies)();
  }, []);
  const {
    data: sizeData,
    loading: indicesLoading
  } = (0, _public.useFetcher)(async () => {
    return (0, _api.getIndicesData)();
  }, []);
  const syntheticsILMPolicies = (_data$filter = data === null || data === void 0 ? void 0 : data.filter(({
    indexTemplates
  }) => indexTemplates === null || indexTemplates === void 0 ? void 0 : indexTemplates.some(indTemp => indTemp.includes('synthetics')))) !== null && _data$filter !== void 0 ? _data$filter : [];
  return {
    data: _policy_labels.policyLabels.map(({
      name,
      label,
      indexTemplate
    }) => {
      var _sizeData$data, _policyIndices$reduce, _policy$policy$phases;
      const policy = syntheticsILMPolicies.find(p => {
        var _p$indexTemplates;
        return (_p$indexTemplates = p.indexTemplates) === null || _p$indexTemplates === void 0 ? void 0 : _p$indexTemplates.some(indTemp => indTemp.includes(indexTemplate));
      });
      const policyIndices = sizeData === null || sizeData === void 0 ? void 0 : (_sizeData$data = sizeData.data) === null || _sizeData$data === void 0 ? void 0 : _sizeData$data.filter(d => {
        var _policy$indices;
        return policy === null || policy === void 0 ? void 0 : (_policy$indices = policy.indices) === null || _policy$indices === void 0 ? void 0 : _policy$indices.includes(d.index);
      });
      let totalSize = (_policyIndices$reduce = policyIndices === null || policyIndices === void 0 ? void 0 : policyIndices.reduce((acc, curr) => {
        var _curr$storeSize;
        return acc + Number((_curr$storeSize = curr === null || curr === void 0 ? void 0 : curr['store.size']) !== null && _curr$storeSize !== void 0 ? _curr$storeSize : 0);
      }, 0)) !== null && _policyIndices$reduce !== void 0 ? _policyIndices$reduce : 0;
      const phases = (_policy$policy$phases = policy === null || policy === void 0 ? void 0 : policy.policy.phases) !== null && _policy$policy$phases !== void 0 ? _policy$policy$phases : {};
      const deletePhase = phases.delete;
      if (name === 'synthetics') {
        var _sizeData$data$reduce, _sizeData$data2;
        totalSize = (_sizeData$data$reduce = sizeData === null || sizeData === void 0 ? void 0 : (_sizeData$data2 = sizeData.data) === null || _sizeData$data2 === void 0 ? void 0 : _sizeData$data2.reduce((acc, curr) => {
          var _curr$storeSize2;
          return acc + Number((_curr$storeSize2 = curr === null || curr === void 0 ? void 0 : curr['store.size']) !== null && _curr$storeSize2 !== void 0 ? _curr$storeSize2 : 0);
        }, 0)) !== null && _sizeData$data$reduce !== void 0 ? _sizeData$data$reduce : 0;
      }
      return {
        name,
        label,
        policy,
        retentionPeriod: (0, _common.formatAge)(deletePhase === null || deletePhase === void 0 ? void 0 : deletePhase.min_age),
        currentSize: (0, _use_object_metrics.formatBytes)(totalSize)
      };
    }),
    error,
    loading: loading || indicesLoading
  };
};
exports.useGetIlmPolicies = useGetIlmPolicies;