"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsJourneyApiResponseType = exports.SyntheticsDataType = exports.ScreenshotRefImageDataType = exports.ScreenshotImageBlobType = exports.ScreenshotBlockType = exports.ScreenshotBlockDocType = exports.RefResultType = exports.JourneyStepType = exports.FullScreenshotType = exports.FailedStepsApiResponseType = void 0;
exports.isFullScreenshot = isFullScreenshot;
exports.isPendingBlock = isPendingBlock;
exports.isRefResult = isRefResult;
exports.isScreenshotBlockDoc = isScreenshotBlockDoc;
exports.isScreenshotImageBlob = isScreenshotImageBlob;
exports.isScreenshotRef = isScreenshotRef;
var _Either = require("fp-ts/lib/Either");
var t = _interopRequireWildcard(require("io-ts"));
var _observer = require("./observer");
var _error_state = require("./error_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This type has some overlap with the Ping type, but it helps avoid runtime type
 * check failures and removes a lot of unnecessary fields that our Synthetics UI code
 * does not care about.
 */
const SyntheticsDataType = exports.SyntheticsDataType = t.partial({
  index: t.number,
  journey: t.type({
    id: t.string,
    name: t.string
  }),
  error: t.partial({
    message: t.string,
    name: t.string,
    stack: t.string
  }),
  package_version: t.string,
  step: t.type({
    status: t.string,
    index: t.number,
    name: t.string,
    duration: t.type({
      us: t.number
    })
  }),
  type: t.string,
  blob: t.string,
  blob_mime: t.string,
  payload: t.partial({
    duration: t.number,
    index: t.number,
    is_navigation_request: t.boolean,
    message: t.string,
    method: t.string,
    name: t.string,
    params: t.partial({
      homepage: t.string
    }),
    source: t.string,
    start: t.number,
    status: t.string,
    ts: t.number,
    type: t.string,
    url: t.string,
    end: t.number,
    text: t.string
  }),
  isFullScreenshot: t.boolean,
  isScreenshotRef: t.boolean
});
const JourneyStepType = exports.JourneyStepType = t.intersection([t.partial({
  config_id: t.string,
  monitor: t.partial({
    duration: t.type({
      us: t.number
    }),
    name: t.string,
    status: t.string,
    type: t.string,
    timespan: t.type({
      gte: t.string,
      lt: t.string
    })
  }),
  observer: _observer.ObserverCodec,
  synthetics: SyntheticsDataType,
  error: t.type({
    message: t.string
  })
}), t.type({
  _id: t.string,
  '@timestamp': t.string,
  monitor: t.type({
    id: t.string,
    check_group: t.string
  }),
  synthetics: t.type({
    type: t.string
  })
})]);
const FailedStepsApiResponseType = exports.FailedStepsApiResponseType = t.type({
  checkGroups: t.array(t.string),
  steps: t.array(JourneyStepType)
});
/**
 * The individual screenshot blocks Synthetics uses to reduce disk footprint.
 */
const ScreenshotBlockType = exports.ScreenshotBlockType = t.type({
  hash: t.string,
  top: t.number,
  left: t.number,
  height: t.number,
  width: t.number
});

/**
 * The old style of screenshot document that contains a full screenshot blob.
 */
const FullScreenshotType = exports.FullScreenshotType = t.type({
  synthetics: t.intersection([t.partial({
    blob: t.string,
    blob_mime: t.string
  }), t.type({
    step: t.type({
      name: t.string
    }),
    type: t.literal('step/screenshot')
  })])
});
function isFullScreenshot(data) {
  return (0, _Either.isRight)(FullScreenshotType.decode(data));
}

/**
 * The ref used by synthetics to organize the blocks needed to recompose a
 * fragmented image.
 */
const RefResultType = exports.RefResultType = t.type({
  '@timestamp': t.string,
  monitor: t.type({
    check_group: t.string
  }),
  screenshot_ref: t.type({
    width: t.number,
    height: t.number,
    blocks: t.array(ScreenshotBlockType)
  }),
  synthetics: t.type({
    package_version: t.string,
    step: t.type({
      name: t.string,
      index: t.number
    }),
    type: t.literal('step/screenshot_ref')
  })
});
function isRefResult(data) {
  return (0, _Either.isRight)(RefResultType.decode(data));
}

/**
 * Represents the result of querying for the legacy-style full screenshot blob.
 */
const ScreenshotImageBlobType = exports.ScreenshotImageBlobType = t.type({
  stepName: t.union([t.null, t.string]),
  maxSteps: t.number,
  src: t.string
});
function isScreenshotImageBlob(data) {
  return (0, _Either.isRight)(ScreenshotImageBlobType.decode(data));
}

/**
 * Represents the block blobs stored by hash. These documents are used to recompose synthetics images.
 */
const ScreenshotBlockDocType = exports.ScreenshotBlockDocType = t.type({
  id: t.string,
  synthetics: t.type({
    blob: t.string,
    blob_mime: t.string
  })
});
function isScreenshotBlockDoc(data) {
  return (0, _Either.isRight)(ScreenshotBlockDocType.decode(data));
}
function isPendingBlock(data) {
  return ['pending', 'loading'].some(s => s === (data === null || data === void 0 ? void 0 : data.status));
}

/**
 * Contains the fields requried by the Synthetics UI when utilizing screenshot refs.
 */
const ScreenshotRefImageDataType = exports.ScreenshotRefImageDataType = t.type({
  stepName: t.union([t.null, t.string]),
  maxSteps: t.number,
  ref: t.type({
    screenshotRef: RefResultType
  })
});
function isScreenshotRef(data) {
  return (0, _Either.isRight)(ScreenshotRefImageDataType.decode(data));
}
const SyntheticsJourneyApiResponseType = exports.SyntheticsJourneyApiResponseType = t.intersection([t.type({
  checkGroup: t.string,
  steps: t.array(JourneyStepType)
}), t.partial({
  details: t.union([t.intersection([t.type({
    timestamp: t.string,
    journey: JourneyStepType
  }), t.partial({
    next: t.type({
      timestamp: t.string,
      checkGroup: t.string
    }),
    previous: t.type({
      timestamp: t.string,
      checkGroup: t.string
    }),
    summary: t.type({
      state: _error_state.ErrorStateCodec
    })
  })]), t.null])
})]);