"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportContentPackFlyout = ExportContentPackFlyout;
var _react = _interopRequireWildcard(require("react"));
var _filesaver = require("@elastic/filesaver");
var _contentPacksSchema = require("@kbn/content-packs-schema");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _use_kibana = require("../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../hooks/use_streams_app_fetch");
var _content_pack_objects_list = require("./content_pack_objects_list");
var _requests = require("./content/requests");
var _content_pack_manifest = require("./content_pack_manifest");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

function ExportContentPackFlyout({
  definition,
  onExport,
  onClose
}) {
  const {
    core: {
      http,
      notifications
    },
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const [manifest, setManifest] = (0, _react.useState)();
  const {
    value: exportResponse,
    loading: isLoadingContentPack
  } = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => {
    if (!definition) {
      return;
    }
    const contentPackRaw = await streamsRepositoryClient.fetch('POST /api/streams/{name}/content/export 2023-10-31', {
      params: {
        path: {
          name: definition.stream.name
        },
        body: {
          name: definition.stream.name,
          description: '',
          version: '1.0.0',
          replaced_patterns: [],
          include: {
            all: {}
          }
        }
      },
      signal
    });
    const contentPack = await (0, _requests.previewContent)({
      http,
      definition,
      // @ts-expect-error upgrade typescript v5.9.3
      file: new File([contentPackRaw], `${definition.stream.name}-1.0.0.zip`, {
        type: 'application/zip'
      })
    });
    const indexPatterns = (0, _lodash.uniq)(contentPack.entries.flatMap(object => (0, _contentPacksSchema.findConfiguration)(object).patterns)).filter(index => !(0, _contentPacksSchema.isIndexPlaceholder)(index));
    setManifest({
      name: contentPack.name,
      version: contentPack.version,
      description: contentPack.description
    });
    return {
      contentPack,
      indexPatterns
    };
  }, [definition, streamsRepositoryClient, http]);
  const [selectedContentPackObjects, setSelectedContentPackObjects] = (0, _react.useState)([]);
  const [replacedIndexPatterns, setReplacedIndexPatterns] = (0, _react.useState)({});
  const [isExporting, setIsExporting] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetailDashboard.exportContent', {
    defaultMessage: 'Export content pack'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, isLoadingContentPack ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : !exportResponse ? null : exportResponse.contentPack.entries ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, exportResponse.indexPatterns.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, null, /*#__PURE__*/_react.default.createElement("details", null, /*#__PURE__*/_react.default.createElement("summary", null, _i18n.i18n.translate('xpack.streams.exportContentFlyout.advancedSettings', {
    defaultMessage: 'Advanced settings'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.exportContentFlyout.detectedIndexPatterns', {
    defaultMessage: 'We detected index patterns that do not match {streamName}* in the content pack. Check the ones you want to replace with the target stream index on import.',
    values: {
      streamName: definition.stream.name
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
    idToSelectedMap: replacedIndexPatterns,
    onChange: id => setReplacedIndexPatterns({
      ...replacedIndexPatterns,
      ...{
        [id]: !replacedIndexPatterns[id]
      }
    }),
    options: exportResponse.indexPatterns.map(index => ({
      id: index,
      label: index
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, manifest ? /*#__PURE__*/_react.default.createElement(_content_pack_manifest.ContentPackMetadata, {
    manifest: manifest,
    onChange: updatedManifest => {
      setManifest(updatedManifest);
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_content_pack_objects_list.ContentPackObjectsList, {
    objects: exportResponse.contentPack.entries,
    onSelectionChange: objects => setSelectedContentPackObjects(objects)
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClose()
  }, "Cancel")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppModalFooterButton",
    isLoading: isExporting,
    isDisabled: isLoadingContentPack || selectedContentPackObjects.length === 0 || (manifest === null || manifest === void 0 ? void 0 : manifest.name.length) === 0,
    fill: true,
    onClick: async () => {
      if (!exportResponse || !manifest || selectedContentPackObjects.length === 0) {
        return;
      }
      setIsExporting(true);
      const replacedPatterns = Object.entries(replacedIndexPatterns).filter(([, selected]) => selected).map(([pattern]) => pattern);
      try {
        const contentPack = await streamsRepositoryClient.fetch('POST /api/streams/{name}/content/export 2023-10-31', {
          params: {
            path: {
              name: definition.stream.name
            },
            body: {
              ...manifest,
              replaced_patterns: replacedPatterns,
              include: {
                objects: {
                  dashboards: selectedContentPackObjects.map(({
                    id
                  }) => id)
                }
              }
            }
          },
          signal: new AbortController().signal
        });
        (0, _filesaver.saveAs)(
        // @ts-expect-error upgrade typescript v5.9.3
        new Blob([contentPack], {
          type: 'application/zip'
        }), `${manifest.name}-${manifest.version}.zip`);
        onExport();
      } catch (err) {
        notifications.toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.streams.failedToExportContentError', {
            defaultMessage: 'Failed to export content pack'
          })
        });
      } finally {
        setIsExporting(true);
      }
    }
  }, _i18n.i18n.translate('xpack.streams.exportContentPackFlyout.exportContentPack', {
    defaultMessage: 'Export content pack'
  }))))));
}