"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGrokPatternSuggestion = useGrokPatternSuggestion;
var _reactHooks = require("@kbn/react-hooks");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _use_kibana = require("../../../../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../../../../hooks/use_streams_app_fetch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGrokPatternSuggestion() {
  const {
    core: {
      notifications
    },
    services: {
      telemetryClient
    },
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const abortController = (0, _reactHooks.useAbortController)();
  return (0, _useAsyncFn.default)(params => {
    if (params === null) {
      return Promise.resolve(undefined); // Reset to initial value
    }
    const finishTrackingAndReport = telemetryClient.startTrackingAIGrokSuggestionLatency({
      name: params.streamName,
      field: params.fieldName,
      connector_id: params.connectorId
    });
    return streamsRepositoryClient.fetch('POST /internal/streams/{name}/processing/_suggestions', {
      signal: abortController.signal,
      params: {
        path: {
          name: params.streamName
        },
        body: {
          field: params.fieldName,
          connectorId: params.connectorId,
          samples: params.samples
        }
      }
    }).then(response => {
      finishTrackingAndReport(response.length || 0, response.map(({
        simulationResult
      }) => simulationResult.processors_metrics['grok-processor'].parsed_rate));
      return response;
    }, error => {
      (0, _use_streams_app_fetch.showErrorToast)(notifications, error);
      throw error;
    });
  });
}