"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Controls = Controls;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _status_filter_group = require("./filters/status_filter_group");
var _type_filter_group = require("./filters/type_filter_group");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Controls({
  controls,
  onChange,
  onRefreshData
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: controls.query,
    onChange: nextQuery => {
      var _nextQuery$query;
      return onChange({
        query: (_nextQuery$query = nextQuery.query) !== null && _nextQuery$query !== void 0 ? _nextQuery$query : undefined
      });
    },
    box: {
      incremental: true
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_type_filter_group.FieldTypeFilterGroup, {
    onChange: onChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_status_filter_group.FieldStatusFilterGroup, {
    onChange: onChange
  })), onRefreshData && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppContentRefreshButton",
    iconType: "refresh",
    onClick: onRefreshData
  }, _i18n.i18n.translate('xpack.streams.schemaEditor.refreshDataButtonLabel', {
    defaultMessage: 'Refresh'
  })))));
}