"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecatedCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeprecatedCalloutComponent = ({
  onMigrate
}) => {
  const update = onMigrate != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onMigrate,
    "data-test-subj": "update-connector-btn"
  }, updateThisConnectorMessage) : /*#__PURE__*/_react.default.createElement("span", null, updateThisConnectorMessage);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    iconType: "warning",
    "data-test-subj": "snDeprecatedCallout",
    color: "warning",
    title: _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.deprecatedCalloutTitle', {
      defaultMessage: 'This connector type is deprecated'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{update} {create} ",
    id: "xpack.stackConnectors.components.serviceNow.appInstallationInfo",
    values: {
      update,
      create: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.deprecatedCalloutCreate', {
        defaultMessage: 'or create a new one.'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const DeprecatedCallout = exports.DeprecatedCallout = /*#__PURE__*/(0, _react.memo)(DeprecatedCalloutComponent);
const updateThisConnectorMessage = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.deprecatedCalloutMigrate', {
  defaultMessage: 'Update this connector,'
});