"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotRestoreUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _http = require("./application/services/http");
var _text = require("./application/services/text");
var _services = require("./application/services");
var _constants2 = require("./application/constants");
var _locator = require("./locator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SnapshotRestoreUIPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "uiMetricService", new _services.UiMetricService(_constants2.UIM_APP_NAME));
    this.initializerContext = initializerContext;
    // Temporary hack to provide the service instances in module files in order to avoid a big refactor
    (0, _http.setUiMetricService)(this.uiMetricService);
  }
  setup(coreSetup, plugins) {
    const config = this.initializerContext.config.get();
    const {
      ui: {
        enabled: isSnapshotRestoreUiEnabled
      }
    } = config;
    if (isSnapshotRestoreUiEnabled) {
      const {
        http
      } = coreSetup;
      const {
        home,
        management,
        usageCollection
      } = plugins;

      // Initialize services
      this.uiMetricService.setup(usageCollection);
      _text.textService.setup(_i18n.i18n);
      _http.httpService.setup(http);
      management.sections.section.data.registerApp({
        id: _constants.PLUGIN.id,
        title: _i18n.i18n.translate('xpack.snapshotRestore.appTitle', {
          defaultMessage: 'Snapshot and Restore'
        }),
        order: 3,
        mount: async params => {
          const {
            mountManagementSection
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/mount_management_section')));
          const services = {
            uiMetricService: this.uiMetricService
          };
          return await mountManagementSection(coreSetup, services, config, params);
        }
      });
      if (home) {
        home.featureCatalogue.register({
          id: _constants.PLUGIN.id,
          title: _i18n.i18n.translate('xpack.snapshotRestore.featureCatalogueTitle', {
            defaultMessage: 'Back up and restore'
          }),
          description: _i18n.i18n.translate('xpack.snapshotRestore.featureCatalogueDescription', {
            defaultMessage: 'Save snapshots to a backup repository, and restore to recover index and cluster state.'
          }),
          icon: 'storage',
          path: '/app/management/data/snapshot_restore',
          showOnHomePage: true,
          category: 'admin',
          order: 630
        });
      }
      plugins.share.url.locators.create(new _locator.SnapshotRestoreLocatorDefinition({
        managementAppLocator: plugins.management.locator
      }));
    }
  }
  start() {}
  stop() {}
}
exports.SnapshotRestoreUIPlugin = SnapshotRestoreUIPlugin;