"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthCallout = HealthCallout;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _paths = require("../../../../../common/locators/paths");
var _use_fetch_slo_health = require("../../../../hooks/use_fetch_slo_health");
var _content_with_inspect_cta = require("../../../slo_details/components/health_callout/content_with_inspect_cta");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CALLOUT_SESSION_STORAGE_KEY = 'slo_health_callout_hidden';
function HealthCallout({
  sloList = []
}) {
  const {
    isLoading,
    isError,
    data: results
  } = (0, _use_fetch_slo_health.useFetchSloHealth)({
    list: sloList
  });
  const [showCallOut, setShowCallOut] = (0, _react.useState)(!sessionStorage.getItem(CALLOUT_SESSION_STORAGE_KEY));
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  if (!showCallOut) {
    return null;
  }
  if (isLoading || isError || results === undefined || (results === null || results === void 0 ? void 0 : results.length) === 0) {
    return null;
  }
  const problematicSloList = results.filter(result => result.health.overall !== 'healthy');
  if (problematicSloList.length === 0) {
    return null;
  }
  const deduplicatedList = (0, _lodash.uniqBy)(problematicSloList, item => item.sloId);
  const dismiss = () => {
    setShowCallOut(false);
    sessionStorage.setItem('slo_health_callout_hidden', 'true');
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "sloHealthCallout",
    color: "danger",
    iconType: isOpen ? 'arrowDown' : 'arrowRight',
    size: "s",
    onClick: e => {
      setIsOpen(!isOpen);
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.sloList.healthCallout.title",
      defaultMessage: "Some SLOs are unhealthy"
    })
  }, isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    alignItems: "flexStart",
    onClick: e => {
      e.stopPropagation();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sloHealthCalloutDescription"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloList.healthCallout.description",
    defaultMessage: "The following {count, plural, one {SLO is} other {SLOs are}} in an unhealthy state. Data may be missing or incomplete. You can inspect {count, plural, one {it} other {each one}} here:",
    values: {
      count: deduplicatedList.length
    }
  })), /*#__PURE__*/_react.default.createElement("ul", null, deduplicatedList.map(result => /*#__PURE__*/_react.default.createElement("li", {
    key: result.sloId
  }, /*#__PURE__*/_react.default.createElement(_content_with_inspect_cta.ContentWithInspectCta, {
    textSize: "xs",
    content: result.sloName,
    url: _paths.paths.sloDetails(result.sloId, result.sloInstanceId, undefined, 'overview')
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "sloHealthCalloutDimissButton",
    color: "text",
    size: "s",
    onClick: dismiss
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloList.healthCallout.buttonDimissLabel",
    defaultMessage: "Dismiss"
  }))))));
}