"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRateStatus = BurnRateStatus;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BurnRateStatus({
  selectedWindow,
  longWindowBurnRate,
  shortWindowBurnRate,
  isLoading
}) {
  const threshold = selectedWindow.threshold;
  const status = (0, _utils.getStatus)(threshold, longWindowBurnRate, shortWindowBurnRate);
  const color = getColor(status);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": "loadingSpinner"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: color,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    style: {
      minHeight: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "default",
    size: "m",
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement("h5", null, getTitle(status)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": "description"
  }, getDescription(shortWindowBurnRate, longWindowBurnRate, selectedWindow)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: `${(0, _numeral.default)(threshold).format('0.[00]')}x`,
    titleColor: "default",
    titleSize: "s",
    textAlign: "right",
    isLoading: isLoading,
    "data-test-subj": "threshold",
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.burnRate.thresholdLabel', {
      defaultMessage: 'Threshold'
    })))
  })))));
}
function getColor(status) {
  return status === 'BREACHED' ? 'danger' : status === 'INCREASING' ? 'warning' : 'success';
}
function getTitle(status) {
  switch (status) {
    case 'BREACHED':
      return _i18n.i18n.translate('xpack.slo.burnRate.breachedStatusTitle', {
        defaultMessage: 'Breached'
      });
    case 'INCREASING':
      return _i18n.i18n.translate('xpack.slo.burnRate.increasingStatusTitle', {
        defaultMessage: 'Increasing'
      });
    case 'RECOVERING':
      return _i18n.i18n.translate('xpack.slo.burnRate.recoveringStatusTitle', {
        defaultMessage: 'Recovering'
      });
    case 'ACCEPTABLE':
    default:
      return _i18n.i18n.translate('xpack.slo.burnRate.acceptableStatusTitle', {
        defaultMessage: 'Acceptable value'
      });
  }
}
function getDescription(shortWindowBurnRate, longWindowBurnRate, selectedWindow) {
  return _i18n.i18n.translate('xpack.slo.burnRate.subtitle', {
    defaultMessage: 'The {longWindowDuration} burn rate is {longWindowBurnRate}x and the {shortWindowDuration} burn rate is {shortWindowBurnRate}x.',
    values: {
      longWindowDuration: `${selectedWindow.longWindow.value}${selectedWindow.longWindow.unit}`,
      longWindowBurnRate: (0, _numeral.default)(longWindowBurnRate).format('0.[00]'),
      shortWindowDuration: `${selectedWindow.shortWindow.value}${selectedWindow.shortWindow.unit}`,
      shortWindowBurnRate: (0, _numeral.default)(shortWindowBurnRate).format('0.[00]')
    }
  });
}