"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUrlServiceRoutes = void 0;
var _register_delete_unused_urls_route = require("./register_delete_unused_urls_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerUrlServiceRoutes = ({
  router,
  core,
  urlExpirationDuration,
  urlLimit,
  logger,
  isEnabled
}) => {
  (0, _register_delete_unused_urls_route.registerDeleteUnusedUrlsRoute)({
    router,
    core,
    urlExpirationDuration,
    urlLimit,
    logger,
    isEnabled
  });
};
exports.registerUrlServiceRoutes = registerUrlServiceRoutes;