"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.passThroughValidationObject = exports.noParamsValidationObject = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const passThroughValidationObject = exports.passThroughValidationObject = {
  body: _zodHelpers.PassThroughAny,
  params: _zodHelpers.PassThroughAny,
  query: _zodHelpers.PassThroughAny
};
const noParamsValidationObject = exports.noParamsValidationObject = {
  params: _zod.z.object({}).strict(),
  query: _zod.z.object({}).strict(),
  body: _zod.z.union([
  // If the route uses POST, the body should be empty object or null
  _zod.z.object({}).strict(), _zod.z.null(),
  // If the route uses GET, body is undefined,
  _zod.z.undefined()])
};