"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAiNavigationTree = void 0;
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _links = require("@kbn/security-solution-navigation/links");
var _icon = require("./icon");
var _stack_management_navigation = require("../stack_management_navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOLUTION_NAME = _i18n.i18n.translate('xpack.securitySolutionServerless.aiNavigation.projectType.title', {
  defaultMessage: 'Elastic AI SOC Engine'
});
const createAiNavigationTree = () => ({
  body: [{
    type: 'navGroup',
    id: 'security_solution_ai_nav',
    title: SOLUTION_NAME,
    icon: _icon.AiNavigationIcon,
    breadcrumbStatus: 'hidden',
    defaultIsCollapsed: false,
    isCollapsible: false,
    children: [{
      breadcrumbStatus: 'hidden',
      children: [{
        id: _securitySolutionNavigation.SecurityPageName.attackDiscovery,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.attackDiscovery)
      }]
    }, {
      breadcrumbStatus: 'hidden',
      children: [{
        link: 'discover'
      }]
    }]
  }],
  footer: [{
    type: 'navItem',
    id: _securitySolutionNavigation.SecurityPageName.landing,
    link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
    icon: 'launch'
  }, {
    type: 'navItem',
    link: 'dev_tools',
    title: _links.i18nStrings.devTools,
    icon: 'editorCodeBlock'
  }, (0, _stack_management_navigation.createStackManagementNavigationTree)()]
});
exports.createAiNavigationTree = createAiNavigationTree;