"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCoverageOverviewRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _detection_engine = require("../../../../../../../common/api/detection_engine");
var _route_validation = require("../../../../../../utils/build_validation/route_validation");
var _utils = require("../../../../routes/utils");
var _handle_coverage_overview_request = require("./handle_coverage_overview_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCoverageOverviewRoute = router => {
  router.versioned.post({
    access: 'internal',
    path: _detection_engine.RULE_MANAGEMENT_COVERAGE_OVERVIEW_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _route_validation.buildRouteValidation)(_detection_engine.CoverageOverviewRequestBody)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const ctx = await context.resolve(['alerting']);
      const responseData = await (0, _handle_coverage_overview_request.handleCoverageOverviewRequest)({
        params: request.body,
        deps: {
          rulesClient: await ctx.alerting.getRulesClient()
        }
      });
      return response.ok({
        body: responseData
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getCoverageOverviewRoute = getCoverageOverviewRoute;