"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSessionViewNavigation = exports.useSessionView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _use_selected_patterns = require("../../../../../data_view_manager/hooks/use_selected_patterns");
var _panel_keys = require("../../../../../flyout/document_details/shared/constants/panel_keys");
var _helpers = require("../../../../../helpers");
var _kibana = require("../../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _timeline = require("../../../../../../common/types/timeline");
var _model = require("../../../../../sourcerer/store/model");
var _constants = require("../../../../../../common/constants");
var _translations2 = require("../../../../../common/components/exit_full_screen/translations");
var _use_full_screen = require("../../../../../common/containers/use_full_screen");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _store = require("../../../../store");
var _defaults = require("../../../../store/defaults");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _telemetry = require("../../../../../common/lib/telemetry");
var _helpers2 = require("../../helpers");
var _containers = require("../../../../../sourcerer/containers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NavigationComponent = ({
  fullScreen,
  globalFullScreen,
  onCloseOverlay,
  isActiveTimelines,
  timelineFullScreen,
  toggleFullScreen,
  graphEventId,
  activeTab
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const title = () => {
    if (isActiveTimelines) {
      return activeTab === _timeline.TimelineTabs.graph ? i18n.CLOSE_ANALYZER : i18n.CLOSE_SESSION;
    } else {
      return graphEventId ? i18n.CLOSE_ANALYZER : i18n.CLOSE_SESSION;
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onCloseOverlay,
    size: "xs",
    "data-test-subj": "close-overlay"
  }, title())), !isActiveTimelines && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: fullScreen ? _translations2.EXIT_FULL_SCREEN : i18n.FULL_SCREEN
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": (0, _helpers2.isFullScreen)({
      globalFullScreen,
      isActiveTimelines,
      timelineFullScreen
    }) ? _translations2.EXIT_FULL_SCREEN : i18n.FULL_SCREEN,
    display: fullScreen ? 'fill' : 'empty',
    color: "primary",
    "data-test-subj": "full-screen",
    iconType: "fullScreen",
    onClick: toggleFullScreen,
    css: (0, _react2.css)`
                margin: ${euiTheme.size.xs} 0;
              `
  }))));
};
NavigationComponent.displayName = 'NavigationComponent';
const Navigation = /*#__PURE__*/_react.default.memo(NavigationComponent);
const useSessionViewNavigation = ({
  scopeId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getScope = (0, _react.useMemo)(() => {
    if ((0, _helpers.isTimelineScope)(scopeId)) {
      return _store.timelineSelectors.getTimelineByIdSelector();
    } else if ((0, _helpers.isInTableScope)(scopeId)) {
      return _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
    }
  }, [scopeId]);
  const {
    globalFullScreen,
    setGlobalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    timelineFullScreen,
    setTimelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const defaults = (0, _helpers.isTimelineScope)(scopeId) ? _defaults.timelineDefaults : _securitysolutionDataTable.tableDefaults;
  const {
    graphEventId,
    sessionViewConfig,
    activeTab,
    prevActiveTab
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _ref;
    return {
      activeTab: _defaults.timelineDefaults.activeTab,
      prevActiveTab: _defaults.timelineDefaults.prevActiveTab,
      ...((_ref = getScope && getScope(state, scopeId)) !== null && _ref !== void 0 ? _ref : defaults)
    };
  });
  const scopedActions = (0, _helpers.getScopedActions)(scopeId);
  const onCloseOverlay = (0, _react.useCallback)(() => {
    const isDataGridFullScreen = document.querySelector('.euiDataGrid--fullScreen') !== null;
    // Since EUI changes these values directly as a side effect, need to add them back on close.
    if (isDataGridFullScreen) {
      if ((0, _helpers.isActiveTimeline)(scopeId)) {
        document.body.classList.add('euiDataGrid__restrictBody');
      } else {
        document.body.classList.add(_constants.SCROLLING_DISABLED_CLASS_NAME, 'euiDataGrid__restrictBody');
      }
    } else {
      if ((0, _helpers.isActiveTimeline)(scopeId)) {
        setTimelineFullScreen(false);
      } else {
        setGlobalFullScreen(false);
      }
    }
    if ((0, _helpers.isActiveTimeline)(scopeId) === false) {
      if (scopedActions) {
        dispatch(scopedActions.updateGraphEventId({
          id: scopeId,
          graphEventId: ''
        }));
        dispatch(scopedActions.updateSessionViewConfig({
          id: scopeId,
          sessionViewConfig: null
        }));
      }
    } else {
      if (activeTab === _timeline.TimelineTabs.graph) {
        if (scopedActions) {
          dispatch(scopedActions.updateGraphEventId({
            id: scopeId,
            graphEventId: ''
          }));
        }
        if (prevActiveTab === _timeline.TimelineTabs.session && !sessionViewConfig) {
          dispatch(_store.timelineActions.setActiveTabTimeline({
            id: scopeId,
            activeTab: _timeline.TimelineTabs.query
          }));
        }
      } else if (activeTab === _timeline.TimelineTabs.session) {
        if ((0, _helpers.isTimelineScope)(scopeId)) {
          if (prevActiveTab === _timeline.TimelineTabs.graph && !graphEventId) {
            dispatch(_store.timelineActions.setActiveTabTimeline({
              id: scopeId,
              activeTab: _timeline.TimelineTabs.query
            }));
          } else {
            dispatch(_store.timelineActions.setActiveTabTimeline({
              id: scopeId,
              activeTab: prevActiveTab
            }));
          }
        }
        if (scopedActions) {
          dispatch(scopedActions.updateSessionViewConfig({
            id: scopeId,
            sessionViewConfig: null
          }));
        }
      }
    }
  }, [setTimelineFullScreen, setGlobalFullScreen, scopedActions, dispatch, scopeId, activeTab, prevActiveTab, sessionViewConfig, graphEventId]);
  const fullScreen = (0, _react.useMemo)(() => (0, _helpers2.isFullScreen)({
    globalFullScreen,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId),
    timelineFullScreen
  }), [globalFullScreen, scopeId, timelineFullScreen]);
  const toggleFullScreen = (0, _react.useCallback)(() => {
    if ((0, _helpers.isActiveTimeline)(scopeId)) {
      setTimelineFullScreen(!timelineFullScreen);
    } else {
      setGlobalFullScreen(!globalFullScreen);
    }
  }, [scopeId, setTimelineFullScreen, timelineFullScreen, setGlobalFullScreen, globalFullScreen]);
  const navigation = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(Navigation, {
      fullScreen: fullScreen,
      globalFullScreen: globalFullScreen,
      activeTab: activeTab,
      onCloseOverlay: onCloseOverlay,
      isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId),
      timelineFullScreen: timelineFullScreen,
      toggleFullScreen: toggleFullScreen,
      graphEventId: graphEventId
    });
  }, [fullScreen, globalFullScreen, activeTab, onCloseOverlay, scopeId, timelineFullScreen, toggleFullScreen, graphEventId]);
  return {
    onCloseOverlay,
    Navigation: navigation
  };
};
exports.useSessionViewNavigation = useSessionViewNavigation;
const useSessionView = ({
  scopeId,
  height
}) => {
  const {
    sessionView,
    telemetry
  } = (0, _kibana.useKibana)().services;
  const getScope = (0, _react.useMemo)(() => {
    if ((0, _helpers.isTimelineScope)(scopeId)) {
      return _store.timelineSelectors.getTimelineByIdSelector();
    } else if ((0, _helpers.isInTableScope)(scopeId)) {
      return _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
    }
  }, [scopeId]);
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    timelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const defaults = (0, _helpers.isTimelineScope)(scopeId) ? _defaults.timelineDefaults : _securitysolutionDataTable.tableDefaults;
  const {
    sessionViewConfig
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _ref2;
    return {
      activeTab: _defaults.timelineDefaults.activeTab,
      prevActiveTab: _defaults.timelineDefaults.prevActiveTab,
      ...((_ref2 = getScope && getScope(state, scopeId)) !== null && _ref2 !== void 0 ? _ref2 : defaults)
    };
  });
  const fullScreen = (0, _react.useMemo)(() => (0, _helpers2.isFullScreen)({
    globalFullScreen,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId),
    timelineFullScreen
  }), [globalFullScreen, scopeId, timelineFullScreen]);
  const {
    newDataViewPickerEnabled
  } = (0, _use_experimental_features.useEnableExperimental)();
  const {
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.detections);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_model.SourcererScopeName.detections);
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const alertsIndex = (0, _react.useMemo)(() => selectedPatterns.join(','), [selectedPatterns]);
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openAlertDetailsFlyout = (0, _react.useCallback)((eventId, onClose) => {
    openFlyout({
      right: {
        id: _panel_keys.DocumentDetailsRightPanelKey,
        params: {
          id: eventId,
          indexName: alertsIndex,
          scopeId
        }
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: scopeId,
      panel: 'right'
    });
  }, [openFlyout, alertsIndex, scopeId, telemetry]);
  const sessionViewComponent = (0, _react.useMemo)(() => {
    const sessionViewSearchBarHeight = 118;
    const heightMinusSearchBar = height ? height - sessionViewSearchBarHeight : undefined;
    return sessionViewConfig !== null ? sessionView.getSessionView({
      ...sessionViewConfig,
      loadAlertDetails: openAlertDetailsFlyout,
      isFullScreen: fullScreen,
      height: heightMinusSearchBar,
      canReadPolicyManagement
    }) : null;
  }, [height, sessionViewConfig, sessionView, openAlertDetailsFlyout, fullScreen, canReadPolicyManagement]);
  return {
    openEventDetailsPanel: openAlertDetailsFlyout,
    SessionView: sessionViewComponent
  };
};
exports.useSessionView = useSessionView;