"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuccessToast = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSuccessToast = (migration, core) => ({
  color: 'success',
  iconType: 'check',
  toastLifeTimeMs: 1000 * 60 * 30,
  // 30 minutes
  title: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rulesService.polling.successTitle', {
    defaultMessage: 'Rules translation complete.'
  }),
  text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: core
  }, /*#__PURE__*/_react.default.createElement(SuccessToastContent, {
    migration: migration
  })), core)
});
exports.getSuccessToast = getSuccessToast;
const SuccessToastContent = ({
  migration
}) => {
  const navigation = {
    deepLinkId: _securitySolutionNavigation.SecurityPageName.siemMigrationsRules,
    path: migration.id
  };
  const {
    navigateTo,
    getAppUrl
  } = (0, _securitySolutionNavigation.useNavigation)();
  const onClick = ev => {
    ev.preventDefault();
    navigateTo(navigation);
  };
  const url = getAppUrl(navigation);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.rulesService.polling.successText",
    defaultMessage: "Migration \"{name}\" has finished. Results have been added to the translated rules page.",
    values: {
      name: migration.name
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClick,
    href: url,
    color: "success"
  }, _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rulesService.polling.successLinkText', {
    defaultMessage: 'Go to translated rules'
  }))));
};